/* CVS $Id: $ */
package de.unibonn.iai.eis.luzzu.semantics.vocabularies; 
import com.hp.hpl.jena.rdf.model.*;
 
/**
 * Vocabulary definitions from src/main/resources/vocabularies/cube/sdmx-attribute.ttl 
 * @author Auto-generated by schemagen on 19 Feb 2015 11:13 
 */
public class SDMXATTRIBUTE {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://purl.org/linked-data/sdmx/2009/attribute#";
    
    /** <p>The namespace of the vocabulary as a string</p>
     *  @see #NS */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    /** <p>The ease and the conditions under which statistical information can be obtained.</p> */
    public static final Property accessibility = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#accessibility" );
    
    /** <p>Closeness of computations or estimates to the exact or true values that the 
     *  statistics were intended to measure.</p>
     */
    public static final Property accuracy = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#accuracy" );
    
    /** <p>Assessment of accuracy, linked to a certain data set or domain, which is summarising 
     *  the various components into one single measure.</p>
     */
    public static final Property accuracyOverall = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#accuracyOverall" );
    
    /** <p>Type of adjustment used, represented by a code.</p> */
    public static final Property adjustCoded = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#adjustCoded" );
    
    /** <p>Textual description of the type of adjustment used.</p> */
    public static final Property adjustDetail = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#adjustDetail" );
    
    /** <p>The set of procedures employed to modify statistical data to enable it to 
     *  conform to national or international standards or to address data quality 
     *  differences when compiling specific data sets.</p>
     */
    public static final Property adjustment = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#adjustment" );
    
    /** <p>Policy on notifying the public of changes in methodology, indicating whether 
     *  the public is notified before a methodological change affects disseminated 
     *  data and, if so, how long before.</p>
     */
    public static final Property advNotice = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#advNotice" );
    
    /** <p>The period of time used as the base of an index number, or to which a constant 
     *  price series refers.</p>
     */
    public static final Property basePer = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#basePer" );
    
    /** <p>The extent to which easily comprehensible metadata are available, where these 
     *  metadata are necessary to give a full understanding of statistical data.</p>
     */
    public static final Property clarity = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#clarity" );
    
    /** <p>Arrangement or division of objects into groups based on characteristics which 
     *  the objects have in common.</p>
     */
    public static final Property classSystem = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#classSystem" );
    
    /** <p>Extent to which statistics are consistent within a given data set.</p> */
    public static final Property coherInternal = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#coherInternal" );
    
    /** <p>Extent to which statistics are reconcilable with those obtained through other 
     *  data sources or statistical domains.</p>
     */
    public static final Property coherXDom = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#coherXDom" );
    
    /** <p>Adequacy of statistics to be combined in different ways and for various uses.</p> */
    public static final Property coherence = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#coherence" );
    
    /** <p>Systematic process of gathering data for official statistics.</p> */
    public static final Property collMethod = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#collMethod" );
    
    /** <p>Supplementary descriptive text which can be attached to data or metadata.</p> */
    public static final Property comment = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#comment" );
    
    /** <p>Extent to which statistics are comparable between different statistical domains.</p> */
    public static final Property comparDomains = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#comparDomains" );
    
    /** <p>Extent to which statistics are comparable between geographical areas.</p> */
    public static final Property comparGeo = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#comparGeo" );
    
    /** <p>Extent to which statistics are comparable or reconcilable over time.</p> */
    public static final Property comparTime = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#comparTime" );
    
    /** <p>The extent to which differences between statistics can be attributed to differences 
     *  between the true values of the statistical characteristics.</p>
     */
    public static final Property comparability = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#comparability" );
    
    /** <p>The organisation compiling the data being reported.</p> */
    public static final Property compilingOrg = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#compilingOrg" );
    
    /** <p>The extent to which all statistics that are needed are available.</p> */
    public static final Property completeness = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#completeness" );
    
    /** <p>A property of data indicating the extent to which their unauthorised disclosure 
     *  could be prejudicial or harmful to the interest of the source or other relevant 
     *  parties.</p>
     */
    public static final Property conf = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#conf" );
    
    /** <p>Rules applied for treating the data set to ensure statistical confidentiality 
     *  and prevent unauthorised disclosure.</p>
     */
    public static final Property confDataTr = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#confDataTr" );
    
    /** <p>Legislative measures or other formal procedures which prevent unauthorised 
     *  disclosure of data that identify a person or economic entity either directly 
     *  or indirectly.</p>
     */
    public static final Property confPolicy = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#confPolicy" );
    
    /** <p>Information about the confidentiality status of the object to which this attribute 
     *  is attached.</p>
     */
    public static final Property confStatus = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#confStatus" );
    
    /** <p>Individual or organisational contact points for the data or metadata, including 
     *  information on how to reach the contact points.</p>
     */
    public static final Property contact = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#contact" );
    
    /** <p>E-mail address of the contact points for the data or metadata.</p> */
    public static final Property contactEmail = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#contactEmail" );
    
    /** <p>Fax number of the contact points for the data or metadata.</p> */
    public static final Property contactFax = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#contactFax" );
    
    /** <p>The area of technical responsibility of the contact, such as "methodology", 
     *  "database management" or "dissemination".</p>
     */
    public static final Property contactFunct = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#contactFunct" );
    
    /** <p>The postal address of the contact points for the data or metadata.</p> */
    public static final Property contactMail = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#contactMail" );
    
    /** <p>The name of the contact points for the data or metadata.</p> */
    public static final Property contactName = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#contactName" );
    
    /** <p>The name of the organisation of the contact points for the data or metadata.</p> */
    public static final Property contactOrganisation = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#contactOrganisation" );
    
    /** <p>The telephone number of the contact points for the data or metadata.</p> */
    public static final Property contactPhone = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#contactPhone" );
    
    /** <p>Costs associated with the collection and production of a statistical product 
     *  and burden on respondents.</p>
     */
    public static final Property costBurden = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#costBurden" );
    
    /** <p>Cost benefit analysis, effectiveness of execution of medium term statistical 
     *  programs, and ensuring efficient use of resources.</p>
     */
    public static final Property costBurdenEff = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#costBurdenEff" );
    
    /** <p>Staff, facilities, computing resources, and financing to undertake statistical 
     *  production.</p>
     */
    public static final Property costBurdenRes = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#costBurdenRes" );
    
    /** <p>The definition of the population that statistics aim to cover.</p> */
    public static final Property coverage = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#coverage" );
    
    /** <p>Main economic or other sectors covered by the statistics.</p> */
    public static final Property coverageSector = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#coverageSector" );
    
    /** <p>The length of time for which data are available.</p> */
    public static final Property coverageTime = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#coverageTime" );
    
    /** <p>Monetary denomination of the object being measured.</p> */
    public static final Property currency = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#currency" );
    
    /** <p>Operations performed on data to derive new information according to a given 
     *  set of rules.</p>
     */
    public static final Property dataComp = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dataComp" );
    
    /** <p>Main characteristics of the data set described in an easily understandable 
     *  manner, referring to the data and indicators disseminated.</p>
     */
    public static final Property dataDescr = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dataDescr" );
    
    /** <p>Activity aimed at detecting and correcting errors, logical inconsistencies 
     *  and suspicious data.</p>
     */
    public static final Property dataEditing = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dataEditing" );
    
    /** <p>Description of the disseminated data.</p> */
    public static final Property dataPres = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dataPres" );
    
    /** <p>Organisation which produces data or metadata</p> */
    public static final Property dataProvider = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dataProvider" );
    
    /** <p>Any change in a value of a statistic released to the public.</p> */
    public static final Property dataRev = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dataRev" );
    
    /** <p>The date on which the data element was inserted or modified in the database.</p> */
    public static final Property dataUpdate = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dataUpdate" );
    
    /** <p>Validation that intermediate calculations leading to statistical outputs have 
     *  been correctly done.</p>
     */
    public static final Property dataValInter = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dataValInter" );
    
    /** <p>Assessment of discrepancies and other problems in statistical outputs.</p> */
    public static final Property dataValOutput = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dataValOutput" );
    
    /** <p>Assessment of discrepancies and other problems related to source data.</p> */
    public static final Property dataValSource = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dataValSource" );
    
    /** <p>Process of monitoring the results of data compilation and ensuring the quality 
     *  of the statistical results.</p>
     */
    public static final Property dataValidation = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dataValidation" );
    
    /** <p>The number of digits of an observation to the right of a decimal point.</p> */
    public static final Property decimals = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#decimals" );
    
    /** <p>Disseminated domain, measure, and time period breakdowns of statistics in 
     *  the dataset.</p>
     */
    public static final Property dissDet = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dissDet" );
    
    /** <p>Media by which statistical data and metadata are disseminated.</p> */
    public static final Property dissFormat = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dissFormat" );
    
    /** <p>The organisation disseminating the data.</p> */
    public static final Property dissOrg = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dissOrg" );
    
    /** <p>References to the most important other data dissemination done.</p> */
    public static final Property dissOther = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dissOther" );
    
    /** <p>Descriptive text and references to methodological documents available.</p> */
    public static final Property docMethod = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#docMethod" );
    
    /** <p>Sequence of characters identifying the data set with which it is associated.</p> */
    public static final Property dsi = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#dsi" );
    
    /** <p>The exact time at which the data could be made available to the public.</p> */
    public static final Property embargoTime = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#embargoTime" );
    
    /** <p>Frequency with which the source data are collected.</p> */
    public static final Property freqColl = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#freqColl" );
    
    /** <p>A further specification of the frequency to include more detailed information 
     *  about the type of frequency and frequencies not commonly used.</p>
     */
    public static final Property freqDetail = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#freqDetail" );
    
    /** <p>The time interval at which the statistics are disseminated over a given time 
     *  period.</p>
     */
    public static final Property freqDiss = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#freqDiss" );
    
    /** <p>Form of consolidation used in presenting the data.</p> */
    public static final Property grossNet = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#grossNet" );
    
    /** <p>Measures to encourage statistical reporting and/or to sanction non-reporting.</p> */
    public static final Property iMResRel = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#iMResRel" );
    
    /** <p>The type of index number used in the statistical production process.</p> */
    public static final Property indType = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#indType" );
    
    /** <p>Legal acts or other formal or informal agreements that assign responsibility 
     *  as well as the authority to an agency for the collection, processing, and 
     *  dissemination of statistics.</p>
     */
    public static final Property instManLaOa = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#instManLaOa" );
    
    /** <p>Arrangements or procedures for data sharing and coordination between data 
     *  producing agencies.</p>
     */
    public static final Property instManShar = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#instManShar" );
    
    /** <p>Set of rules or other formal set of instructions assigning responsibility 
     *  as well as the authority to an organisation for the collection, processing, 
     *  and dissemination of statistics.</p>
     */
    public static final Property instMandate = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#instMandate" );
    
    /** <p>The organisation or other expert body that maintains a domain-specific data 
     *  or metadata structure definition.</p>
     */
    public static final Property mAgency = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#mAgency" );
    
    /** <p>Date of the latest certification provided by the domain manager to confirm 
     *  that the metadata posted are still up-to-date, even if the content has not 
     *  been amended.</p>
     */
    public static final Property metaCertified = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#metaCertified" );
    
    /** <p>Date of last update of the content of the metadata.</p> */
    public static final Property metaLastUpdate = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#metaLastUpdate" );
    
    /** <p>Date of the latest dissemination of the metadata.</p> */
    public static final Property metaPosted = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#metaPosted" );
    
    /** <p>The date on which the metadata element was inserted or modified in the database.</p> */
    public static final Property metaUpdate = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#metaUpdate" );
    
    /** <p>Information on whether micro-data are also disseminated.</p> */
    public static final Property microDatAcc = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#microDatAcc" );
    
    /** <p>Regular or ad-hoc press releases linked to the data.</p> */
    public static final Property newsRel = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#newsRel" );
    
    /** <p>Error in sample estimates which cannot be attributed to sampling fluctuations.</p> */
    public static final Property nonsamplingErr = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#nonsamplingErr" );
    
    /** <p>The observation, at a time series break period, that was calculated using 
     *  the old methodology.</p>
     */
    public static final Property obsPreBreak = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#obsPreBreak" );
    
    /** <p>Information on the quality of a value or an unusual or missing value.</p> */
    public static final Property obsStatus = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#obsStatus" );
    
    /** <p>Information about on-line databases in which the disseminated data can be 
     *  accessed.</p>
     */
    public static final Property onlineDb = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#onlineDb" );
    
    /** <p>An addressable subdivision of an organization.</p> */
    public static final Property organisationUnit = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#organisationUnit" );
    
    /** <p>The data identifier as found in the originating database.</p> */
    public static final Property origDataId = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#origDataId" );
    
    /** <p>The standard, skill and ability suitable for producing statistics of good 
     *  quality.</p>
     */
    public static final Property prof = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#prof" );
    
    /** <p>Provision for assuring the qualifications of staff and allowing staff to perform 
     *  their functions without intervention motivated by non-statistical objectives.</p>
     */
    public static final Property profCond = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#profCond" );
    
    /** <p>Description of the elements providing assurances that statistics are produced 
     *  on an impartial basis.</p>
     */
    public static final Property profImp = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#profImp" );
    
    /** <p>Describes the elements providing assurances that the choices of sources and 
     *  statistical techniques as well as decisions about dissemination are informed 
     *  solely by statistical considerations.</p>
     */
    public static final Property profMeth = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#profMeth" );
    
    /** <p>Describes the elements providing assurances that the statistical entity is 
     *  entitled to comment on erroneous interpretation and misuse of statistics.</p>
     */
    public static final Property profStatCom = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#profStatCom" );
    
    /** <p>Regular or ad-hoc publications in which the data are made available to the 
     *  public.</p>
     */
    public static final Property publications = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#publications" );
    
    /** <p>Time lag between the actual delivery of the data and the target date when 
     *  it should have been delivered.</p>
     */
    public static final Property punctuality = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#punctuality" );
    
    /** <p>Overall assessment of data quality, based on standard quality criteria.</p> */
    public static final Property qualityAssmnt = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#qualityAssmnt" );
    
    /** <p>Guidelines focusing on quality in general and dealing with quality of statistical 
     *  programmes, including measures for ensuring the efficient use of resources.</p>
     */
    public static final Property qualityAssure = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#qualityAssure" );
    
    /** <p>Documentation on procedures applied for quality management and quality assessment.</p> */
    public static final Property qualityDoc = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#qualityDoc" );
    
    /** <p>Systems and frameworks in place within an organisation to manage the quality 
     *  of statistical products and processes.</p>
     */
    public static final Property qualityMgmnt = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#qualityMgmnt" );
    
    /** <p>Processes and standards employed in calculating statistical aggregates.</p> */
    public static final Property recording = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#recording" );
    
    /** <p>Dates or periods to which the observations used to compile the weights refer.</p> */
    public static final Property refPerWgts = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#refPerWgts" );
    
    /** <p>Access to the release calendar information.</p> */
    public static final Property relCalAccess = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#relCalAccess" );
    
    /** <p>The schedule of statistical release dates.</p> */
    public static final Property relCalPolicy = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#relCalPolicy" );
    
    /** <p>Legal acts and other agreements pertaining to data access.</p> */
    public static final Property relComment = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#relComment" );
    
    /** <p>Legal acts and other agreements pertaining to data access.</p> */
    public static final Property relPolLegActs = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#relPolLegActs" );
    
    /** <p>Dissemination of the release policy to the public.</p> */
    public static final Property relPolTra = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#relPolTra" );
    
    /** <p>The policy for release of the data to users, the scope of dissemination (eg, 
     *  to the public, to selected users), how users are informed that the data are 
     *  being released, and whether the policy provides determines the dissemination 
     *  of statistical data to all users.</p>
     */
    public static final Property relPolUsAc = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#relPolUsAc" );
    
    /** <p>Rules for disseminating statistical data to interested parties.</p> */
    public static final Property relPolicy = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#relPolicy" );
    
    /** <p>The degree to which statistical information meets the real or perceived needs 
     *  of clients.</p>
     */
    public static final Property relevance = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#relevance" );
    
    /** <p>The organisation that supplies the data for a given instance of the statistics.</p> */
    public static final Property repAgency = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#repAgency" );
    
    /** <p>Policy aimed at ensuring the transparency of disseminated data, whereby preliminary 
     *  data are compiled that are later revised.</p>
     */
    public static final Property revPolicy = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#revPolicy" );
    
    /** <p>Information on the data revision practice.</p> */
    public static final Property revPractice = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#revPractice" );
    
    /** <p>Information about data revision studies and analyses.</p> */
    public static final Property revStudy = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#revStudy" );
    
    /** <p>The process of selecting a number of cases from all the cases in a particular 
     *  group or universe.</p>
     */
    public static final Property sampling = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#sampling" );
    
    /** <p>That part of the difference between a population value and an estimate thereof, 
     *  derived from a random sample, which is due to the fact that only a subset 
     *  of the population is enumerated.</p>
     */
    public static final Property samplingErr = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#samplingErr" );
    
    /** <p>Characteristics and components of the raw statistical data used for compiling 
     *  statistical aggregates.</p>
     */
    public static final Property sourceType = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#sourceType" );
    
    /** <p>Statistical characteristics of statistical observations.</p> */
    public static final Property statConcDef = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#statConcDef" );
    
    /** <p>The total membership or population or "universe" of a defined class of people, 
     *  objects or events.</p>
     */
    public static final Property statPop = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#statPop" );
    
    /** <p>Entity for which information is sought and for which statistics are ultimately 
     *  compiled.</p>
     */
    public static final Property statUnit = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#statUnit" );
    
    /** <p>Technical format in which time is represented for the measured phenomenon.</p> */
    public static final Property timeFormat = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#timeFormat" );
    
    /** <p>The lapse of time between the end of a reference period and dissemination 
     *  of the data.</p>
     */
    public static final Property timeOutput = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#timeOutput" );
    
    /** <p>Dates or periods during which the observations have been collected (such as 
     *  middle, average or end of period) to compile the indicator for the target 
     *  reference period.</p>
     */
    public static final Property timePerCollect = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#timePerCollect" );
    
    /** <p>The time between the end of a reference period and actual receipt of the data 
     *  by the compiling agency.</p>
     */
    public static final Property timeSource = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#timeSource" );
    
    /** <p>Length of time between data availability and the event or phenomenon they 
     *  describe.</p>
     */
    public static final Property timeliness = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#timeliness" );
    
    /** <p>Textual label used as identification of a statistical object.</p> */
    public static final Property title = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#title" );
    
    /** <p>Additional textual information on the unit of measure.</p> */
    public static final Property unitMeasDetail = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#unitMeasDetail" );
    
    /** <p>The unit in which the data values are measured.</p> */
    public static final Property unitMeasure = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#unitMeasure" );
    
    /** <p>Exponent in base 10 specified so that multiplying the observation numeric 
     *  values by 10^UNIT_MULT gives a value expressed in the UNIT.</p>
     */
    public static final Property unitMult = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#unitMult" );
    
    /** <p>Description of users and their respective needs with respect to the statistical 
     *  data.</p>
     */
    public static final Property userNeeds = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#userNeeds" );
    
    /** <p>Measure to determine user satisfaction.</p> */
    public static final Property userSat = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#userSat" );
    
    /** <p>The definition of the price per unit, for goods and services flows and asset 
     *  stocks.</p>
     */
    public static final Property valuation = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#valuation" );
    
    /** <p>The secondary area, as opposed to reference area, to which the measured data 
     *  is in relation.</p>
     */
    public static final Property visArea = m_model.createProperty( "http://purl.org/linked-data/sdmx/2009/attribute#visArea" );
    
}
