/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.semantics.configuration;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDFS;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.DAQ;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalModelConf {
    private static Dataset semanticModel = DatasetFactory.create((Model)ModelFactory.createDefaultModel());
    static final Logger logger = LoggerFactory.getLogger(InternalModelConf.class);

    private static String guessNamespace(Model temp) {
        List res = temp.listSubjectsWithProperty(RDFS.subClassOf, (RDFNode)DAQ.Category).toList();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        for (Resource r : res) {
            String ns;
            tempMap.put(ns, tempMap.containsKey(ns = r.getNameSpace()) ? (Integer)tempMap.get(ns) + 1 : 1);
        }
        return (String)InternalModelConf.sortByValue(tempMap).keySet().toArray()[0];
    }

    public static Model getDAQModel() {
        return semanticModel.getNamedModel("http://purl.org/eis/vocab/daq#");
    }

    public static Model getFlatModel() {
        Model m = ModelFactory.createDefaultModel();
        Iterator iter = semanticModel.listNames();
        while (iter.hasNext()) {
            m.add(semanticModel.getNamedModel((String)iter.next()));
        }
        return m;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    static {
        Model temp = ModelFactory.createDefaultModel();
        temp.read(InternalModelConf.class.getResourceAsStream("/vocabularies/daq/daq.trig"), null, "N3");
        semanticModel.addNamedModel("http://purl.org/eis/vocab/daq#", temp);
        File externalsFolder = new File("externals/vocabs/");
        if (externalsFolder.exists()) {
            File[] listOfOntologies;
            for (File ontology : listOfOntologies = externalsFolder.listFiles()) {
                temp = ModelFactory.createDefaultModel();
                logger.debug("Loading ontology : {} ", (Object)ontology.getName());
                temp.read(ontology.getPath(), "N3");
                try {
                    semanticModel.addNamedModel(InternalModelConf.guessNamespace(temp), temp);
                }
                catch (Exception e) {
                    logger.debug("Could not load model " + ontology.getPath());
                }
            }
        }
    }
}

