/* CVS $Id: $ */
package de.unibonn.iai.eis.luzzu.semantics.vocabularies; 
import com.hp.hpl.jena.rdf.model.*;
 
/**
 * Vocabulary definitions from src/main/resources/vocabularies/daq/daq.ttl 
 * @author Auto-generated by schemagen on 02 Nov 2015 13:52 
 */
public class DAQ {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://purl.org/eis/vocab/daq#";
    
    /** <p>The namespace of the vocabulary as a string</p>
     *  @see #NS */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    /** <p>**Deprecated Property**. The computedBy property defines the Agent that computed 
     *  a metric on a dataset.</p>
     */
    public static final Property computedBy = m_model.createProperty( "http://purl.org/eis/vocab/daq#computedBy" );
    
    /** <p>Quality metrics can be (in principle) calculated on various forms of data 
     *  (such as datasets, graphs, set of triples etc...). This vocabulary allow the 
     *  owner/user of such RDF data to calculate metrics on multiple (and different) 
     *  resources.</p>
     */
    public static final Property computedOn = m_model.createProperty( "http://purl.org/eis/vocab/daq#computedOn" );
    
    /** <p>Each metric should have an expect data type for it's observed value (e.g. 
     *  xsd:boolean, xsd:double etc...)</p>
     */
    public static final Property expectedDataType = m_model.createProperty( "http://purl.org/eis/vocab/daq#expectedDataType" );
    
    /** <p>The category concept classifies dimensions related to the measurement of quality 
     *  for a specific criteria. This is an abstract property and should not be used 
     *  directly. Specific sub-properties should be inherited for different dimensions.</p>
     */
    public static final Property hasDimension = m_model.createProperty( "http://purl.org/eis/vocab/daq#hasDimension" );
    
    /** <p>A dimension is an abstract concept which groups an number of more concrete 
     *  metrics to measure quality of a dataset. This is an abstract property and 
     *  should not be used directly. Specific sub-properties should be inherited for 
     *  different metrics.</p>
     */
    public static final Property hasMetric = m_model.createProperty( "http://purl.org/eis/vocab/daq#hasMetric" );
    
    /** <p>Computed metrics can have 1 or more quality observations, where each computed 
     *  resource has one observation.</p>
     */
    public static final Property hasObservation = m_model.createProperty( "http://purl.org/eis/vocab/daq#hasObservation" );
    
    /** <p>This property flags true if an assessed observation of a metric gives an estimate 
     *  result instead of a more accurate one.</p>
     */
    public static final Property isEstimate = m_model.createProperty( "http://purl.org/eis/vocab/daq#isEstimate" );
    
    /** <p>Represents the metric being observed.</p> */
    public static final Property metric = m_model.createProperty( "http://purl.org/eis/vocab/daq#metric" );
    
    /** <p>A metric might require a number of external resources (e.g. a gold standard) 
     *  in order to be able to measure the quality. In order to cater for the most 
     *  generic requirement, this property links a metric to the required resource 
     *  (e.g. a URI to the gold standard dataset used).</p>
     */
    public static final Property requires = m_model.createProperty( "http://purl.org/eis/vocab/daq#requires" );
    
    /** <p>Each metric will have a value computed. In order to deal with the different 
     *  return type of the metric computation, this property links a metric with a 
     *  value object (e.g. boolean, double, Literal).</p>
     */
    public static final Property value = m_model.createProperty( "http://purl.org/eis/vocab/daq#value" );
    
    /** <p>The highest level of quality metric is a category. A category groups a number 
     *  of dimensions relevant to each other which aims at measuring the quality of 
     *  a dataset from different aspects. Categories are provided as subclasses of 
     *  this abstract class, which is not intended for direct usage.</p>
     */
    public static final Resource Category = m_model.createResource( "http://purl.org/eis/vocab/daq#Category" );
    
    /** <p>Each dimension is part of a larger group called category (See daq:Category). 
     *  Each dimension has a number of metrics which are associated to it. A dimension 
     *  is linked with a category using the daq:hasDimension property. Dimensions 
     *  are provided as subclasses of this abstract class, which is not intended for 
     *  direct usage.</p>
     */
    public static final Resource Dimension = m_model.createResource( "http://purl.org/eis/vocab/daq#Dimension" );
    
    /** <p>The smallest unit of measuring a quality dimension is a metric. A metric belongs 
     *  to exactly one dimension. Each metric has one or more observations ( exttt{daq:hasObservation}), 
     *  which records data quality assessment value following a computation. Metrics 
     *  are provided as subclasses of this abstract class, which is not intended for 
     *  direct usage.</p>
     */
    public static final Resource Metric = m_model.createResource( "http://purl.org/eis/vocab/daq#Metric" );
    
    /** <p>A quality observation represents the statistical and provenance information 
     *  of the attached metric's assessment activity.</p>
     */
    public static final Resource Observation = m_model.createResource( "http://purl.org/eis/vocab/daq#Observation" );
    
    /** <p>Defines a quality graph which will contain all metadata about quality metrics 
     *  on the dataset.</p>
     */
    public static final Resource QualityGraph = m_model.createResource( "http://purl.org/eis/vocab/daq#QualityGraph" );
    
    public static final Resource __ = m_model.createResource( "http://purl.org/eis/vocab/daq#" );
    
    public static final Resource dsd = m_model.createResource( "http://purl.org/eis/vocab/daq#dsd" );
    
}
