/* CVS $Id: $ */
package de.unibonn.iai.eis.luzzu.semantics.vocabularies; 
import com.hp.hpl.jena.rdf.model.*;
 
/**
 * Vocabulary definitions from src/main/resources/vocabularies/prov/prov.ttl 
 * @author Auto-generated by schemagen on 02 Nov 2015 13:52 
 */
public class PROV {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://www.w3.org/ns/prov#";
    
    /** <p>The namespace of the vocabulary as a string</p>
     *  @see #NS */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    /** <p>The ontology's owl:versionInfo as a string</p> */
    public static final String VERSION_INFO = "Working Group Note version 2013-04-30";
    
    /** <p>An object property to express the accountability of an agent towards another 
     *  agent. The subordinate agent acted on behalf of the responsible agent in an 
     *  actual activity.</p>
     */
    public static final Property actedOnBehalfOf = m_model.createProperty( "http://www.w3.org/ns/prov#actedOnBehalfOf" );
    
    public static final Property activity = m_model.createProperty( "http://www.w3.org/ns/prov#activity" );
    
    public static final Property activityOfInfluence = m_model.createProperty( "http://www.w3.org/ns/prov#activityOfInfluence" );
    
    public static final Property agent = m_model.createProperty( "http://www.w3.org/ns/prov#agent" );
    
    public static final Property agentOfInfluence = m_model.createProperty( "http://www.w3.org/ns/prov#agentOfInfluence" );
    
    public static final Property alternateOf = m_model.createProperty( "http://www.w3.org/ns/prov#alternateOf" );
    
    public static final Property aq = m_model.createProperty( "http://www.w3.org/ns/prov#aq" );
    
    /** <p>prov:asInBundle is used to specify which bundle the general entity of a prov:mentionOf 
     *  property is described. When :x prov:mentionOf :y and :y is described in Bundle 
     *  :b, the triple :x prov:asInBundle :b is also asserted to cite the Bundle in 
     *  which :y was described.</p>
     */
    public static final Property asInBundle = m_model.createProperty( "http://www.w3.org/ns/prov#asInBundle" );
    
    /** <p>This property has multiple RDFS domains to suit multiple OWL Profiles. See 
     *  &lt;a href="#owl-profile"&gt;PROV-O OWL Profile&lt;/a&gt;.The Location of 
     *  any resource.</p>
     */
    public static final Property atLocation = m_model.createProperty( "http://www.w3.org/ns/prov#atLocation" );
    
    /** <p>The time at which an InstantaneousEvent occurred, in the form of xsd:dateTime.</p> */
    public static final Property atTime = m_model.createProperty( "http://www.w3.org/ns/prov#atTime" );
    
    /** <p>Classify prov-o terms into three categories, including 'starting-point', 'qualifed', 
     *  and 'extended'. This classification is used by the prov-o html document to 
     *  gently introduce prov-o terms to its users.</p>
     */
    public static final Property category = m_model.createProperty( "http://www.w3.org/ns/prov#category" );
    
    /** <p>Classify prov-o terms into six components according to prov-dm, including 
     *  'agents-responsibility', 'alternate', 'annotations', 'collections', 'derivations', 
     *  and 'entities-activities'. This classification is used so that readers of 
     *  prov-o specification can find its correspondence with the prov-dm specification.</p>
     */
    public static final Property component = m_model.createProperty( "http://www.w3.org/ns/prov#component" );
    
    /** <p>A reference to the principal section of the PROV-CONSTRAINTS document that 
     *  describes this concept.</p>
     */
    public static final Property constraints = m_model.createProperty( "http://www.w3.org/ns/prov#constraints" );
    
    public static final Property contributed = m_model.createProperty( "http://www.w3.org/ns/prov#contributed" );
    
    /** <p>A definition quoted from PROV-DM or PROV-CONSTRAINTS that describes the concept 
     *  expressed with this OWL term.</p>
     */
    public static final Property definition = m_model.createProperty( "http://www.w3.org/ns/prov#definition" );
    
    public static final Property derivedByInsertionFrom = m_model.createProperty( "http://www.w3.org/ns/prov#derivedByInsertionFrom" );
    
    public static final Property derivedByRemovalFrom = m_model.createProperty( "http://www.w3.org/ns/prov#derivedByRemovalFrom" );
    
    /** <p>relates a generic provenance query service resource (type prov:ServiceDescription) 
     *  to a specific query service description (e.g. a prov:DirectQueryService or 
     *  a sd:Service).</p>
     */
    public static final Property describesService = m_model.createProperty( "http://www.w3.org/ns/prov#describesService" );
    
    public static final Property dictionary = m_model.createProperty( "http://www.w3.org/ns/prov#dictionary" );
    
    /** <p>A reference to the principal section of the PROV-DM document that describes 
     *  this concept.</p>
     */
    public static final Property dm = m_model.createProperty( "http://www.w3.org/ns/prov#dm" );
    
    /** <p>A note by the OWL development team about how this term expresses the PROV-DM 
     *  concept, or how it should be used in context of semantic web or linked data.</p>
     */
    public static final Property editorialNote = m_model.createProperty( "http://www.w3.org/ns/prov#editorialNote" );
    
    /** <p>When the prov-o term does not have a definition drawn from prov-dm, and the 
     *  prov-o editor provides one.</p>
     */
    public static final Property editorsDefinition = m_model.createProperty( "http://www.w3.org/ns/prov#editorsDefinition" );
    
    public static final Property ended = m_model.createProperty( "http://www.w3.org/ns/prov#ended" );
    
    /** <p>The time at which an activity ended. See also prov:startedAtTime.</p> */
    public static final Property endedAtTime = m_model.createProperty( "http://www.w3.org/ns/prov#endedAtTime" );
    
    public static final Property entity = m_model.createProperty( "http://www.w3.org/ns/prov#entity" );
    
    public static final Property entityOfInfluence = m_model.createProperty( "http://www.w3.org/ns/prov#entityOfInfluence" );
    
    public static final Property generalizationOf = m_model.createProperty( "http://www.w3.org/ns/prov#generalizationOf" );
    
    public static final Property generated = m_model.createProperty( "http://www.w3.org/ns/prov#generated" );
    
    public static final Property generatedAsDerivation = m_model.createProperty( "http://www.w3.org/ns/prov#generatedAsDerivation" );
    
    /** <p>The time at which an entity was completely created and is available for use.</p> */
    public static final Property generatedAtTime = m_model.createProperty( "http://www.w3.org/ns/prov#generatedAtTime" );
    
    /** <p>This property has multiple RDFS domains to suit multiple OWL Profiles. See 
     *  &lt;a href="#owl-profile"&gt;PROV-O OWL Profile&lt;/a&gt;.The _optional_ Activity 
     *  of an Influence, which used, generated, invalidated, or was the responsibility 
     *  of some Entity. This property is _not_ used by ActivityInfluence (use prov:activity 
     *  instead).</p>
     */
    public static final Property hadActivity = m_model.createProperty( "http://www.w3.org/ns/prov#hadActivity" );
    
    public static final Property hadDelegate = m_model.createProperty( "http://www.w3.org/ns/prov#hadDelegate" );
    
    public static final Property hadDerivation = m_model.createProperty( "http://www.w3.org/ns/prov#hadDerivation" );
    
    public static final Property hadDictionaryMember = m_model.createProperty( "http://www.w3.org/ns/prov#hadDictionaryMember" );
    
    /** <p>The _optional_ Generation involved in an Entity's Derivation.</p> */
    public static final Property hadGeneration = m_model.createProperty( "http://www.w3.org/ns/prov#hadGeneration" );
    
    public static final Property hadInfluence = m_model.createProperty( "http://www.w3.org/ns/prov#hadInfluence" );
    
    public static final Property hadMember = m_model.createProperty( "http://www.w3.org/ns/prov#hadMember" );
    
    /** <p>The _optional_ Plan adopted by an Agent in Association with some Activity. 
     *  Plan specifications are out of the scope of this specification.</p>
     */
    public static final Property hadPlan = m_model.createProperty( "http://www.w3.org/ns/prov#hadPlan" );
    
    public static final Property hadPrimarySource = m_model.createProperty( "http://www.w3.org/ns/prov#hadPrimarySource" );
    
    public static final Property hadRevision = m_model.createProperty( "http://www.w3.org/ns/prov#hadRevision" );
    
    /** <p>The _optional_ Role that an Entity assumed in the context of an Activity. 
     *  For example, :baking prov:used :spoon; prov:qualified [ a prov:Usage; prov:entity 
     *  :spoon; prov:hadRole roles:mixing_implement ].This property has multiple RDFS 
     *  domains to suit multiple OWL Profiles. See &lt;a href="#owl-profile"&gt;PROV-O 
     *  OWL Profile&lt;/a&gt;.</p>
     */
    public static final Property hadRole = m_model.createProperty( "http://www.w3.org/ns/prov#hadRole" );
    
    /** <p>The _optional_ Usage involved in an Entity's Derivation.</p> */
    public static final Property hadUsage = m_model.createProperty( "http://www.w3.org/ns/prov#hadUsage" );
    
    /** <p>Indicates anchor URI for a potentially dynamic resource instance.</p> */
    public static final Property has_anchor = m_model.createProperty( "http://www.w3.org/ns/prov#has_anchor" );
    
    /** <p>Indicates a provenance-URI for a resource; the resource identified by this 
     *  property presents a provenance record about its subject or anchor resource.</p>
     */
    public static final Property has_provenance = m_model.createProperty( "http://www.w3.org/ns/prov#has_provenance" );
    
    /** <p>Indicates a provenance query service that can access provenance related to 
     *  its subject or anchor resource.</p>
     */
    public static final Property has_query_service = m_model.createProperty( "http://www.w3.org/ns/prov#has_query_service" );
    
    public static final Property influenced = m_model.createProperty( "http://www.w3.org/ns/prov#influenced" );
    
    /** <p>Subproperties of prov:influencer are used to cite the object of an unqualified 
     *  PROV-O triple whose predicate is a subproperty of prov:wasInfluencedBy (e.g. 
     *  prov:used, prov:wasGeneratedBy). prov:influencer is used much like rdf:object 
     *  is used.</p>
     */
    public static final Property influencer = m_model.createProperty( "http://www.w3.org/ns/prov#influencer" );
    
    public static final Property informed = m_model.createProperty( "http://www.w3.org/ns/prov#informed" );
    
    public static final Property insertedKeyEntityPair = m_model.createProperty( "http://www.w3.org/ns/prov#insertedKeyEntityPair" );
    
    public static final Property invalidated = m_model.createProperty( "http://www.w3.org/ns/prov#invalidated" );
    
    /** <p>The time at which an entity was invalidated (i.e., no longer usable).</p> */
    public static final Property invalidatedAtTime = m_model.createProperty( "http://www.w3.org/ns/prov#invalidatedAtTime" );
    
    /** <p>PROV-O does not define all property inverses. The directionalities defined 
     *  in PROV-O should be given preference over those not defined. However, if users 
     *  wish to name the inverse of a PROV-O property, the local name given by prov:inverse 
     *  should be used.</p>
     */
    public static final Property inverse = m_model.createProperty( "http://www.w3.org/ns/prov#inverse" );
    
    public static final Property locationOf = m_model.createProperty( "http://www.w3.org/ns/prov#locationOf" );
    
    /** <p>prov:mentionOf is used to specialize an entity as described in another bundle. 
     *  It is to be used in conjuction with prov:asInBundle. prov:asInBundle is used 
     *  to cite the Bundle in which the generalization was mentioned.</p>
     */
    public static final Property mentionOf = m_model.createProperty( "http://www.w3.org/ns/prov#mentionOf" );
    
    /** <p>A reference to the principal section of the PROV-DM document that describes 
     *  this concept.A reference to the principal section of the PROV-M document that 
     *  describes this concept.</p>
     */
    public static final Property n = m_model.createProperty( "http://www.w3.org/ns/prov#n" );
    
    public static final Property pairEntity = m_model.createProperty( "http://www.w3.org/ns/prov#pairEntity" );
    
    public static final Property pairKey = m_model.createProperty( "http://www.w3.org/ns/prov#pairKey" );
    
    /** <p>Relates a resource to a provenance pingback service that may receive additional 
     *  provenance links about the resource.</p>
     */
    public static final Property pingback = m_model.createProperty( "http://www.w3.org/ns/prov#pingback" );
    
    /** <p>Relates a provenance service to a URI template string for constructing provenance-URIs.</p> */
    public static final Property provenanceUriTemplate = m_model.createProperty( "http://www.w3.org/ns/prov#provenanceUriTemplate" );
    
    /** <p>If this Activity prov:wasAssociatedWith Agent :ag, then it can qualify the 
     *  Association using prov:qualifiedAssociation [ a prov:Association; prov:agent 
     *  :ag; :foo :bar ].</p>
     */
    public static final Property qualifiedAssociation = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedAssociation" );
    
    public static final Property qualifiedAssociationOf = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedAssociationOf" );
    
    /** <p>If this Entity prov:wasAttributedTo Agent :ag, then it can qualify how it 
     *  was influenced using prov:qualifiedAttribution [ a prov:Attribution; prov:agent 
     *  :ag; :foo :bar ].</p>
     */
    public static final Property qualifiedAttribution = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedAttribution" );
    
    public static final Property qualifiedAttributionOf = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedAttributionOf" );
    
    /** <p>If this Activity prov:wasInformedBy Activity :a, then it can qualify how it 
     *  was influenced using prov:qualifiedCommunication [ a prov:Communication; prov:activity 
     *  :a; :foo :bar ].</p>
     */
    public static final Property qualifiedCommunication = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedCommunication" );
    
    public static final Property qualifiedCommunicationOf = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedCommunicationOf" );
    
    /** <p>If this Agent prov:actedOnBehalfOf Agent :ag, then it can qualify how with 
     *  prov:qualifiedResponsibility [ a prov:Responsibility; prov:agent :ag; :foo 
     *  :bar ].</p>
     */
    public static final Property qualifiedDelegation = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedDelegation" );
    
    public static final Property qualifiedDelegationOf = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedDelegationOf" );
    
    /** <p>If this Entity prov:wasDerivedFrom Entity :e, then it can qualify how it was 
     *  derived using prov:qualifiedDerivation [ a prov:Derivation; prov:entity :e; 
     *  :foo :bar ].</p>
     */
    public static final Property qualifiedDerivation = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedDerivation" );
    
    public static final Property qualifiedDerivationOf = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedDerivationOf" );
    
    /** <p>If this Activity prov:wasEndedBy Entity :e1, then it can qualify how it was 
     *  ended using prov:qualifiedEnd [ a prov:End; prov:entity :e1; :foo :bar ].</p>
     */
    public static final Property qualifiedEnd = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedEnd" );
    
    public static final Property qualifiedEndOf = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedEndOf" );
    
    /** <p>This annotation property links a subproperty of prov:wasInfluencedBy with 
     *  the subclass of prov:Influence and the qualifying property that are used to 
     *  qualify it. Example annotation: prov:wasGeneratedBy prov:qualifiedForm prov:qualifiedGeneration, 
     *  prov:Generation . Then this unqualified assertion: :entity1 prov:wasGeneratedBy 
     *  :activity1 . can be qualified by adding: :entity1 prov:qualifiedGeneration 
     *  :entity1Gen . :entity1Gen a prov:Generation, prov:Influence; prov:activity 
     *  :activity1; :customValue 1337 . Note how the value of the unqualified influence 
     *  (prov:wasGeneratedBy :activity1) is mirrored as the value of the prov:activity 
     *  (or prov:entity, or prov:agent) property on the influence class.</p>
     */
    public static final Property qualifiedForm = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedForm" );
    
    /** <p>If this Activity prov:generated Entity :e, then it can qualify how it performed 
     *  the Generation using prov:qualifiedGeneration [ a prov:Generation; prov:entity 
     *  :e; :foo :bar ].</p>
     */
    public static final Property qualifiedGeneration = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedGeneration" );
    
    public static final Property qualifiedGenerationOf = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedGenerationOf" );
    
    /** <p>Because prov:qualifiedInfluence is a broad relation, the more specific relations 
     *  (qualifiedCommunication, qualifiedDelegation, qualifiedEnd, etc.) should be 
     *  used when applicable.</p>
     */
    public static final Property qualifiedInfluence = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedInfluence" );
    
    public static final Property qualifiedInfluenceOf = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedInfluenceOf" );
    
    public static final Property qualifiedInsertion = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedInsertion" );
    
    /** <p>If this Entity prov:wasInvalidatedBy Activity :a, then it can qualify how 
     *  it was invalidated using prov:qualifiedInvalidation [ a prov:Invalidation; 
     *  prov:activity :a; :foo :bar ].</p>
     */
    public static final Property qualifiedInvalidation = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedInvalidation" );
    
    public static final Property qualifiedInvalidationOf = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedInvalidationOf" );
    
    /** <p>If this Entity prov:hadPrimarySource Entity :e, then it can qualify how using 
     *  prov:qualifiedPrimarySource [ a prov:PrimarySource; prov:entity :e; :foo :bar 
     *  ].</p>
     */
    public static final Property qualifiedPrimarySource = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedPrimarySource" );
    
    /** <p>If this Entity prov:wasQuotedFrom Entity :e, then it can qualify how using 
     *  prov:qualifiedQuotation [ a prov:Quotation; prov:entity :e; :foo :bar ].</p>
     */
    public static final Property qualifiedQuotation = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedQuotation" );
    
    public static final Property qualifiedQuotationOf = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedQuotationOf" );
    
    public static final Property qualifiedRemoval = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedRemoval" );
    
    /** <p>If this Entity prov:wasRevisionOf Entity :e, then it can qualify how it was 
     *  revised using prov:qualifiedRevision [ a prov:Revision; prov:entity :e; :foo 
     *  :bar ].</p>
     */
    public static final Property qualifiedRevision = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedRevision" );
    
    public static final Property qualifiedSourceOf = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedSourceOf" );
    
    /** <p>If this Activity prov:wasStartedBy Entity :e1, then it can qualify how it 
     *  was started using prov:qualifiedStart [ a prov:Start; prov:entity :e1; :foo 
     *  :bar ].</p>
     */
    public static final Property qualifiedStart = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedStart" );
    
    public static final Property qualifiedStartOf = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedStartOf" );
    
    /** <p>If this Activity prov:used Entity :e, then it can qualify how it used it using 
     *  prov:qualifiedUsage [ a prov:Usage; prov:entity :e; :foo :bar ].</p>
     */
    public static final Property qualifiedUsage = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedUsage" );
    
    public static final Property qualifiedUsingActivity = m_model.createProperty( "http://www.w3.org/ns/prov#qualifiedUsingActivity" );
    
    public static final Property quotedAs = m_model.createProperty( "http://www.w3.org/ns/prov#quotedAs" );
    
    public static final Property removedKey = m_model.createProperty( "http://www.w3.org/ns/prov#removedKey" );
    
    public static final Property revisedEntity = m_model.createProperty( "http://www.w3.org/ns/prov#revisedEntity" );
    
    public static final Property sharesDefinitionWith = m_model.createProperty( "http://www.w3.org/ns/prov#sharesDefinitionWith" );
    
    public static final Property specializationOf = m_model.createProperty( "http://www.w3.org/ns/prov#specializationOf" );
    
    public static final Property started = m_model.createProperty( "http://www.w3.org/ns/prov#started" );
    
    /** <p>The time at which an activity started. See also prov:endedAtTime.</p> */
    public static final Property startedAtTime = m_model.createProperty( "http://www.w3.org/ns/prov#startedAtTime" );
    
    /** <p>Classes and properties used to qualify relationships are annotated with prov:unqualifiedForm 
     *  to indicate the property used to assert an unqualified provenance relation.</p>
     */
    public static final Property unqualifiedForm = m_model.createProperty( "http://www.w3.org/ns/prov#unqualifiedForm" );
    
    /** <p>A prov:Entity that was used by this prov:Activity. For example, :baking prov:used 
     *  :spoon, :egg, :oven .</p>
     */
    public static final Property used = m_model.createProperty( "http://www.w3.org/ns/prov#used" );
    
    public static final Property value = m_model.createProperty( "http://www.w3.org/ns/prov#value" );
    
    public static final Property wasActivityOfInfluence = m_model.createProperty( "http://www.w3.org/ns/prov#wasActivityOfInfluence" );
    
    public static final Property wasAssociateFor = m_model.createProperty( "http://www.w3.org/ns/prov#wasAssociateFor" );
    
    /** <p>An prov:Agent that had some (unspecified) responsibility for the occurrence 
     *  of this prov:Activity.</p>
     */
    public static final Property wasAssociatedWith = m_model.createProperty( "http://www.w3.org/ns/prov#wasAssociatedWith" );
    
    /** <p>Attribution is the ascribing of an entity to an agent.</p> */
    public static final Property wasAttributedTo = m_model.createProperty( "http://www.w3.org/ns/prov#wasAttributedTo" );
    
    /** <p>The more specific subproperties of prov:wasDerivedFrom (i.e., prov:wasQuotedFrom, 
     *  prov:wasRevisionOf, prov:hadPrimarySource) should be used when applicable.</p>
     */
    public static final Property wasDerivedFrom = m_model.createProperty( "http://www.w3.org/ns/prov#wasDerivedFrom" );
    
    /** <p>End is when an activity is deemed to have ended. An end may refer to an entity, 
     *  known as trigger, that terminated the activity.</p>
     */
    public static final Property wasEndedBy = m_model.createProperty( "http://www.w3.org/ns/prov#wasEndedBy" );
    
    public static final Property wasGeneratedBy = m_model.createProperty( "http://www.w3.org/ns/prov#wasGeneratedBy" );
    
    /** <p>Because prov:wasInfluencedBy is a broad relation, its more specific subproperties 
     *  (e.g. prov:wasInformedBy, prov:actedOnBehalfOf, prov:wasEndedBy, etc.) should 
     *  be used when applicable.This property has multiple RDFS domains to suit multiple 
     *  OWL Profiles. See &lt;a href="#owl-profile"&gt;PROV-O OWL Profile&lt;/a&gt;.</p>
     */
    public static final Property wasInfluencedBy = m_model.createProperty( "http://www.w3.org/ns/prov#wasInfluencedBy" );
    
    /** <p>An activity a2 is dependent on or informed by another activity a1, by way 
     *  of some unspecified entity that is generated by a1 and used by a2.</p>
     */
    public static final Property wasInformedBy = m_model.createProperty( "http://www.w3.org/ns/prov#wasInformedBy" );
    
    public static final Property wasInvalidatedBy = m_model.createProperty( "http://www.w3.org/ns/prov#wasInvalidatedBy" );
    
    public static final Property wasMemberOf = m_model.createProperty( "http://www.w3.org/ns/prov#wasMemberOf" );
    
    public static final Property wasPlanOf = m_model.createProperty( "http://www.w3.org/ns/prov#wasPlanOf" );
    
    public static final Property wasPrimarySourceOf = m_model.createProperty( "http://www.w3.org/ns/prov#wasPrimarySourceOf" );
    
    /** <p>An entity is derived from an original entity by copying, or 'quoting', some 
     *  or all of it.</p>
     */
    public static final Property wasQuotedFrom = m_model.createProperty( "http://www.w3.org/ns/prov#wasQuotedFrom" );
    
    /** <p>A revision is a derivation that revises an entity into a revised version.</p> */
    public static final Property wasRevisionOf = m_model.createProperty( "http://www.w3.org/ns/prov#wasRevisionOf" );
    
    public static final Property wasRoleIn = m_model.createProperty( "http://www.w3.org/ns/prov#wasRoleIn" );
    
    /** <p>Start is when an activity is deemed to have started. A start may refer to 
     *  an entity, known as trigger, that initiated the activity.</p>
     */
    public static final Property wasStartedBy = m_model.createProperty( "http://www.w3.org/ns/prov#wasStartedBy" );
    
    public static final Property wasUsedBy = m_model.createProperty( "http://www.w3.org/ns/prov#wasUsedBy" );
    
    public static final Property wasUsedInDerivation = m_model.createProperty( "http://www.w3.org/ns/prov#wasUsedInDerivation" );
    
    public static final Resource Accept = m_model.createResource( "http://www.w3.org/ns/prov#Accept" );
    
    public static final Resource Activity = m_model.createResource( "http://www.w3.org/ns/prov#Activity" );
    
    /** <p>ActivityInfluence provides additional descriptions of an Activity's binary 
     *  influence upon any other kind of resource. Instances of ActivityInfluence 
     *  use the prov:activity property to cite the influencing Activity.It is not 
     *  recommended that the type ActivityInfluence be asserted without also asserting 
     *  one of its more specific subclasses.</p>
     */
    public static final Resource ActivityInfluence = m_model.createResource( "http://www.w3.org/ns/prov#ActivityInfluence" );
    
    public static final Resource Agent = m_model.createResource( "http://www.w3.org/ns/prov#Agent" );
    
    /** <p>It is not recommended that the type AgentInfluence be asserted without also 
     *  asserting one of its more specific subclasses.AgentInfluence provides additional 
     *  descriptions of an Agent's binary influence upon any other kind of resource. 
     *  Instances of AgentInfluence use the prov:agent property to cite the influencing 
     *  Agent.</p>
     */
    public static final Resource AgentInfluence = m_model.createResource( "http://www.w3.org/ns/prov#AgentInfluence" );
    
    /** <p>An instance of prov:Association provides additional descriptions about the 
     *  binary prov:wasAssociatedWith relation from an prov:Activity to some prov:Agent 
     *  that had some responsiblity for it. For example, :baking prov:wasAssociatedWith 
     *  :baker; prov:qualifiedAssociation [ a prov:Association; prov:agent :baker; 
     *  :foo :bar ].</p>
     */
    public static final Resource Association = m_model.createResource( "http://www.w3.org/ns/prov#Association" );
    
    /** <p>An instance of prov:Attribution provides additional descriptions about the 
     *  binary prov:wasAttributedTo relation from an prov:Entity to some prov:Agent 
     *  that had some responsible for it. For example, :cake prov:wasAttributedTo 
     *  :baker; prov:qualifiedAttribution [ a prov:Attribution; prov:entity :baker; 
     *  :foo :bar ].</p>
     */
    public static final Resource Attribution = m_model.createResource( "http://www.w3.org/ns/prov#Attribution" );
    
    /** <p>Note that there are kinds of bundles (e.g. handwritten letters, audio recordings, 
     *  etc.) that are not expressed in PROV-O, but can be still be described by PROV-O.</p>
     */
    public static final Resource Bundle = m_model.createResource( "http://www.w3.org/ns/prov#Bundle" );
    
    public static final Resource Collection = m_model.createResource( "http://www.w3.org/ns/prov#Collection" );
    
    /** <p>An instance of prov:Communication provides additional descriptions about the 
     *  binary prov:wasInformedBy relation from an informed prov:Activity to the prov:Activity 
     *  that informed it. For example, :you_jumping_off_bridge prov:wasInformedBy 
     *  :everyone_else_jumping_off_bridge; prov:qualifiedCommunication [ a prov:Communication; 
     *  prov:activity :everyone_else_jumping_off_bridge; :foo :bar ].</p>
     */
    public static final Resource Communication = m_model.createResource( "http://www.w3.org/ns/prov#Communication" );
    
    public static final Resource Contribute = m_model.createResource( "http://www.w3.org/ns/prov#Contribute" );
    
    public static final Resource Contributor = m_model.createResource( "http://www.w3.org/ns/prov#Contributor" );
    
    public static final Resource Copyright = m_model.createResource( "http://www.w3.org/ns/prov#Copyright" );
    
    public static final Resource Create = m_model.createResource( "http://www.w3.org/ns/prov#Create" );
    
    public static final Resource Creator = m_model.createResource( "http://www.w3.org/ns/prov#Creator" );
    
    /** <p>An instance of prov:Delegation provides additional descriptions about the 
     *  binary prov:actedOnBehalfOf relation from a performing prov:Agent to some 
     *  prov:Agent for whom it was performed. For example, :mixing prov:wasAssociatedWith 
     *  :toddler . :toddler prov:actedOnBehalfOf :mother; prov:qualifiedDelegation 
     *  [ a prov:Delegation; prov:entity :mother; :foo :bar ].</p>
     */
    public static final Resource Delegation = m_model.createResource( "http://www.w3.org/ns/prov#Delegation" );
    
    /** <p>The more specific forms of prov:Derivation (i.e., prov:Revision, prov:Quotation, 
     *  prov:PrimarySource) should be asserted if they apply.An instance of prov:Derivation 
     *  provides additional descriptions about the binary prov:wasDerivedFrom relation 
     *  from some derived prov:Entity to another prov:Entity from which it was derived. 
     *  For example, :chewed_bubble_gum prov:wasDerivedFrom :unwrapped_bubble_gum; 
     *  prov:qualifiedDerivation [ a prov:Derivation; prov:entity :unwrapped_bubble_gum; 
     *  :foo :bar ].</p>
     */
    public static final Resource Derivation = m_model.createResource( "http://www.w3.org/ns/prov#Derivation" );
    
    /** <p>This concept allows for the provenance of the dictionary, but also of its 
     *  constituents to be expressed. Such a notion of dictionary corresponds to a 
     *  wide variety of concrete data structures, such as a maps or associative arrays.A 
     *  given dictionary forms a given structure for its members. A different structure 
     *  (obtained either by insertion or removal of members) constitutes a different 
     *  dictionary.</p>
     */
    public static final Resource Dictionary = m_model.createResource( "http://www.w3.org/ns/prov#Dictionary" );
    
    /** <p>Type for a generic provenance query service. Mainly for use in RDF provenance 
     *  query service descriptions, to facilitate discovery in linked data environments.</p>
     */
    public static final Resource DirectQueryService = m_model.createResource( "http://www.w3.org/ns/prov#DirectQueryService" );
    
    public static final Resource EmptyCollection = m_model.createResource( "http://www.w3.org/ns/prov#EmptyCollection" );
    
    public static final Resource EmptyDictionary = m_model.createResource( "http://www.w3.org/ns/prov#EmptyDictionary" );
    
    /** <p>An instance of prov:End provides additional descriptions about the binary 
     *  prov:wasEndedBy relation from some ended prov:Activity to an prov:Entity that 
     *  ended it. For example, :ball_game prov:wasEndedBy :buzzer; prov:qualifiedEnd 
     *  [ a prov:End; prov:entity :buzzer; :foo :bar; prov:atTime '2012-03-09T08:05:08-05:00'^^xsd:dateTime 
     *  ].</p>
     */
    public static final Resource End = m_model.createResource( "http://www.w3.org/ns/prov#End" );
    
    public static final Resource Entity = m_model.createResource( "http://www.w3.org/ns/prov#Entity" );
    
    /** <p>It is not recommended that the type EntityInfluence be asserted without also 
     *  asserting one of its more specific subclasses.EntityInfluence provides additional 
     *  descriptions of an Entity's binary influence upon any other kind of resource. 
     *  Instances of EntityInfluence use the prov:entity property to cite the influencing 
     *  Entity.</p>
     */
    public static final Resource EntityInfluence = m_model.createResource( "http://www.w3.org/ns/prov#EntityInfluence" );
    
    /** <p>An instance of prov:Generation provides additional descriptions about the 
     *  binary prov:wasGeneratedBy relation from a generated prov:Entity to the prov:Activity 
     *  that generated it. For example, :cake prov:wasGeneratedBy :baking; prov:qualifiedGeneration 
     *  [ a prov:Generation; prov:activity :baking; :foo :bar ].</p>
     */
    public static final Resource Generation = m_model.createResource( "http://www.w3.org/ns/prov#Generation" );
    
    /** <p>An instance of prov:Influence provides additional descriptions about the binary 
     *  prov:wasInfluencedBy relation from some influenced Activity, Entity, or Agent 
     *  to the influencing Activity, Entity, or Agent. For example, :stomach_ache 
     *  prov:wasInfluencedBy :spoon; prov:qualifiedInfluence [ a prov:Influence; prov:entity 
     *  :spoon; :foo :bar ] . Because prov:Influence is a broad relation, the more 
     *  specific relations (Communication, Delegation, End, etc.) should be used when 
     *  applicable.Because prov:Influence is a broad relation, its most specific subclasses 
     *  (e.g. prov:Communication, prov:Delegation, prov:End, prov:Revision, etc.) 
     *  should be used when applicable.</p>
     */
    public static final Resource Influence = m_model.createResource( "http://www.w3.org/ns/prov#Influence" );
    
    public static final Resource Insertion = m_model.createResource( "http://www.w3.org/ns/prov#Insertion" );
    
    /** <p>An instantaneous event, or event for short, happens in the world and marks 
     *  a change in the world, in its activities and in its entities. The term 'event' 
     *  is commonly used in process algebra with a similar meaning. Events represent 
     *  communications or interactions; they are assumed to be atomic and instantaneous.</p>
     */
    public static final Resource InstantaneousEvent = m_model.createResource( "http://www.w3.org/ns/prov#InstantaneousEvent" );
    
    /** <p>An instance of prov:Invalidation provides additional descriptions about the 
     *  binary prov:wasInvalidatedBy relation from an invalidated prov:Entity to the 
     *  prov:Activity that invalidated it. For example, :uncracked_egg prov:wasInvalidatedBy 
     *  :baking; prov:qualifiedInvalidation [ a prov:Invalidation; prov:activity :baking; 
     *  :foo :bar ].</p>
     */
    public static final Resource Invalidation = m_model.createResource( "http://www.w3.org/ns/prov#Invalidation" );
    
    public static final Resource KeyEntityPair = m_model.createResource( "http://www.w3.org/ns/prov#KeyEntityPair" );
    
    public static final Resource Location = m_model.createResource( "http://www.w3.org/ns/prov#Location" );
    
    public static final Resource Modify = m_model.createResource( "http://www.w3.org/ns/prov#Modify" );
    
    public static final Resource Organization = m_model.createResource( "http://www.w3.org/ns/prov#Organization" );
    
    public static final Resource Person = m_model.createResource( "http://www.w3.org/ns/prov#Person" );
    
    /** <p>There exist no prescriptive requirement on the nature of plans, their representation, 
     *  the actions or steps they consist of, or their intended goals. Since plans 
     *  may evolve over time, it may become necessary to track their provenance, so 
     *  plans themselves are entities. Representing the plan explicitly in the provenance 
     *  can be useful for various tasks: for example, to validate the execution as 
     *  represented in the provenance record, to manage expectation failures, or to 
     *  provide explanations.</p>
     */
    public static final Resource Plan = m_model.createResource( "http://www.w3.org/ns/prov#Plan" );
    
    /** <p>An instance of prov:PrimarySource provides additional descriptions about the 
     *  binary prov:hadPrimarySource relation from some secondary prov:Entity to an 
     *  earlier, primary prov:Entity. For example, :blog prov:hadPrimarySource :newsArticle; 
     *  prov:qualifiedPrimarySource [ a prov:PrimarySource; prov:entity :newsArticle; 
     *  :foo :bar ] .</p>
     */
    public static final Resource PrimarySource = m_model.createResource( "http://www.w3.org/ns/prov#PrimarySource" );
    
    public static final Resource Publish = m_model.createResource( "http://www.w3.org/ns/prov#Publish" );
    
    public static final Resource Publisher = m_model.createResource( "http://www.w3.org/ns/prov#Publisher" );
    
    /** <p>An instance of prov:Quotation provides additional descriptions about the binary 
     *  prov:wasQuotedFrom relation from some taken prov:Entity from an earlier, larger 
     *  prov:Entity. For example, :here_is_looking_at_you_kid prov:wasQuotedFrom :casablanca_script; 
     *  prov:qualifiedQuotation [ a prov:Quotation; prov:entity :casablanca_script; 
     *  :foo :bar ].</p>
     */
    public static final Resource Quotation = m_model.createResource( "http://www.w3.org/ns/prov#Quotation" );
    
    public static final Resource Removal = m_model.createResource( "http://www.w3.org/ns/prov#Removal" );
    
    public static final Resource Replace = m_model.createResource( "http://www.w3.org/ns/prov#Replace" );
    
    /** <p>An instance of prov:Revision provides additional descriptions about the binary 
     *  prov:wasRevisionOf relation from some newer prov:Entity to an earlier prov:Entity. 
     *  For example, :draft_2 prov:wasRevisionOf :draft_1; prov:qualifiedRevision 
     *  [ a prov:Revision; prov:entity :draft_1; :foo :bar ].</p>
     */
    public static final Resource Revision = m_model.createResource( "http://www.w3.org/ns/prov#Revision" );
    
    public static final Resource RightsAssignment = m_model.createResource( "http://www.w3.org/ns/prov#RightsAssignment" );
    
    public static final Resource RightsHolder = m_model.createResource( "http://www.w3.org/ns/prov#RightsHolder" );
    
    public static final Resource Role = m_model.createResource( "http://www.w3.org/ns/prov#Role" );
    
    /** <p>Type for a generic provenance query service. Mainly for use in RDF provenance 
     *  query service descriptions, to facilitate discovery in linked data environments.</p>
     */
    public static final Resource ServiceDescription = m_model.createResource( "http://www.w3.org/ns/prov#ServiceDescription" );
    
    public static final Resource SoftwareAgent = m_model.createResource( "http://www.w3.org/ns/prov#SoftwareAgent" );
    
    /** <p>An instance of prov:Start provides additional descriptions about the binary 
     *  prov:wasStartedBy relation from some started prov:Activity to an prov:Entity 
     *  that started it. For example, :foot_race prov:wasStartedBy :bang; prov:qualifiedStart 
     *  [ a prov:Start; prov:entity :bang; :foo :bar; prov:atTime '2012-03-09T08:05:08-05:00'^^xsd:dateTime 
     *  ] .</p>
     */
    public static final Resource Start = m_model.createResource( "http://www.w3.org/ns/prov#Start" );
    
    public static final Resource Submit = m_model.createResource( "http://www.w3.org/ns/prov#Submit" );
    
    /** <p>An instance of prov:Usage provides additional descriptions about the binary 
     *  prov:used relation from some prov:Activity to an prov:Entity that it used. 
     *  For example, :keynote prov:used :podium; prov:qualifiedUsage [ a prov:Usage; 
     *  prov:entity :podium; :foo :bar ].</p>
     */
    public static final Resource Usage = m_model.createResource( "http://www.w3.org/ns/prov#Usage" );
    
    public static final Resource __ = m_model.createResource( "file:///Users/jeremy/Documents/Workspaces/Luzzu/luzzu/luzzu-semantics/src/main/resources/vocabularies/prov/prov.ttl#" );
    
    /** <p>This document is published by the Provenance Working Group (http://www.w3.org/2011/prov/wiki/Main_Page). 
     *  If you wish to make comments regarding this document, please send them to 
     *  public-prov-comments@w3.org (subscribe public-prov-comments-request@w3.org, 
     *  archives http://lists.w3.org/ Archives/Public/public-prov-comments/). All 
     *  feedback is welcome.</p>
     */
    public static final Resource ___INSTANCE = m_model.createResource( "http://www.w3.org/ns/prov#" );
    
    public static final Resource prov_20130312 = m_model.createResource( "http://www.w3.org/ns/prov-20130312" );
    
    /** <p>0.2This document is published by the Provenance Working Group (http://www.w3.org/2011/prov/wiki/Main_Page). 
     *  If you wish to make comments regarding this document, please send them to 
     *  public-prov-comments@w3.org (subscribe public-prov-comments-request@w3.org, 
     *  archives http://lists.w3.org/Archives/Public/public-prov-comments/). All feedback 
     *  is welcome.</p>
     */
    public static final Resource ___INSTANCE1 = m_model.createResource( "http://www.w3.org/ns/prov-aq#" );
    
    /** <p>This document is published by the Provenance Working Group (http://www.w3.org/2011/prov/wiki/Main_Page). 
     *  If you wish to make comments regarding this document, please send them to 
     *  public-prov-comments@w3.org (subscribe public-prov-comments-request@w3.org, 
     *  archives http://lists.w3.org/Archives/Public/public-prov-comments/). All feedback 
     *  is welcome.</p>
     */
    public static final Resource ___INSTANCE2 = m_model.createResource( "http://www.w3.org/ns/prov-dc#" );
    
    /** <p>This document is published by the Provenance Working Group (http://www.w3.org/2011/prov/wiki/Main_Page). 
     *  If you wish to make comments regarding this document, please send them to 
     *  public-prov-comments@w3.org (subscribe public-prov-comments-request@w3.org, 
     *  archives http://lists.w3.org/Archives/Public/public-prov-comments/). All feedback 
     *  is welcome.</p>
     */
    public static final Resource ___INSTANCE3 = m_model.createResource( "http://www.w3.org/ns/prov-dictionary#" );
    
    public static final Resource prov_links = m_model.createResource( "http://www.w3.org/ns/prov-links" );
    
    /** <p>This document is published by the Provenance Working Group (http://www.w3.org/2011/prov/wiki/Main_Page). 
     *  If you wish to make comments regarding this document, please send them to 
     *  public-prov-comments@w3.org (subscribe public-prov-comments-request@w3.org, 
     *  archives http://lists.w3.org/Archives/Public/public-prov-comments/ ). All 
     *  feedback is welcome.</p>
     */
    public static final Resource ___INSTANCE4 = m_model.createResource( "http://www.w3.org/ns/prov-links#" );
    
    public static final Resource prov_o = m_model.createResource( "http://www.w3.org/ns/prov-o" );
    
    /** <p>This document is published by the Provenance Working Group (http://www.w3.org/2011/prov/wiki/Main_Page). 
     *  If you wish to make comments regarding this document, please send them to 
     *  public-prov-comments@w3.org (subscribe public-prov-comments-request@w3.org, 
     *  archives http://lists.w3.org/Archives/Public/public-prov-comments/). All feedback 
     *  is welcome.</p>
     */
    public static final Resource ___INSTANCE5 = m_model.createResource( "http://www.w3.org/ns/prov-o#" );
    
    public static final Resource prov_o_20120312 = m_model.createResource( "http://www.w3.org/ns/prov-o-20120312" );
    
    public static final Resource prov_o_20130430 = m_model.createResource( "http://www.w3.org/ns/prov-o-20130430" );
    
    public static final Resource prov_o_inverses = m_model.createResource( "http://www.w3.org/ns/prov-o-inverses" );
    
    public static final Resource ___INSTANCE6 = m_model.createResource( "http://www.w3.org/ns/prov-o-inverses#" );
    
    public static final Resource prov_o_inverses_20120312 = m_model.createResource( "http://www.w3.org/ns/prov-o-inverses-20120312" );
    
}
