/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.semantics.utilities;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import de.unibonn.iai.eis.luzzu.semantics.configuration.InternalModelConf;
import de.unibonn.iai.eis.luzzu.semantics.datatypes.Observation;
import de.unibonn.iai.eis.luzzu.semantics.utilities.Commons;
import de.unibonn.iai.eis.luzzu.semantics.utilities.SPARQLHelper;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.CUBE;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.DAQ;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.riot.RDFDataMgr;

public class DAQHelper {
    private DAQHelper() {
    }

    public static String getClassLabel(Resource uri) {
        StmtIterator iter = InternalModelConf.getDAQModel().listStatements(uri, RDFS.label, (RDFNode)null);
        String label = "";
        while (iter.hasNext()) {
            label = iter.nextStatement().getObject().toString();
        }
        return label;
    }

    public static String getDimensionLabel(Resource metricURI) {
        return DAQHelper.getClassLabel(DAQHelper.getDomainResource(metricURI));
    }

    public static String getCategoryLabel(Resource metricURI) {
        Resource dim = DAQHelper.getDomainResource(metricURI);
        Resource cat = DAQHelper.getDomainResource(dim);
        return DAQHelper.getClassLabel(cat);
    }

    public static Resource getDimensionResource(Resource metricURI) {
        return DAQHelper.getDomainResource(metricURI);
    }

    public static Resource getCategoryResource(Resource metricURI) {
        Resource intermediate = DAQHelper.getDomainResource(metricURI);
        return DAQHelper.getDomainResource(intermediate);
    }

    private static Resource getDomainResource(Resource uri) {
        String whereClause = "?prop  " + SPARQLHelper.toSPARQL((Resource)RDFS.range) + SPARQLHelper.toSPARQL(uri) + " . ";
        whereClause = whereClause + " ?prop " + SPARQLHelper.toSPARQL((Resource)RDFS.domain) + " ?domain .";
        Model m = InternalModelConf.getFlatModel();
        String query = SPARQLHelper.SELECT_STATEMENT.replace("[variables]", "?domain").replace("[whereClauses]", whereClause);
        Resource r = null;
        Query qry = QueryFactory.create((String)query);
        QueryExecution qe = QueryExecutionFactory.create((Query)qry, (Model)m);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            r = rs.next().get("domain").asResource();
        }
        return r;
    }

    public static Resource getPropertyResource(Resource uri) {
        String whereClause = "?prop  " + SPARQLHelper.toSPARQL((Resource)RDFS.range) + SPARQLHelper.toSPARQL(uri) + " . ";
        Model m = InternalModelConf.getFlatModel();
        String query = SPARQLHelper.SELECT_STATEMENT.replace("[variables]", "?prop").replace("[whereClauses]", whereClause);
        Resource r = null;
        Query qry = QueryFactory.create((String)query);
        QueryExecution qe = QueryExecutionFactory.create((Query)qry, (Model)m);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            r = rs.next().get("prop").asResource();
        }
        return r;
    }

    public static String getClassDescription(Resource uri) {
        StmtIterator iter = InternalModelConf.getDAQModel().listStatements(uri, RDFS.comment, (RDFNode)null);
        String label = "";
        while (iter.hasNext()) {
            label = iter.nextStatement().getObject().toString();
        }
        return label;
    }

    public static Map<String, List<Observation>> getQualityMetadataObservations(String datasetMetadataUri) {
        Dataset d = RDFDataMgr.loadDataset((String)datasetMetadataUri);
        Resource graph = (Resource)d.getDefaultModel().listSubjectsWithProperty(RDF.type, (RDFNode)DAQ.QualityGraph).next();
        Model qualityMD = d.getNamedModel(graph.getURI());
        HashMap<String, List<Observation>> map = new HashMap<String, List<Observation>>();
        ResIterator iter = qualityMD.listResourcesWithProperty(RDF.type, (RDFNode)CUBE.Observation);
        while (iter.hasNext()) {
            Resource res = (Resource)iter.next();
            Resource metricURI = qualityMD.listObjectsOfProperty(res, DAQ.metric).next().asResource();
            Resource metricType = qualityMD.listObjectsOfProperty(metricURI, RDF.type).next().asResource();
            Date date = null;
            try {
                date = DAQHelper.toDateFormat(qualityMD.listObjectsOfProperty(res, DC.date).next().asLiteral().getValue().toString());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Double value = qualityMD.listObjectsOfProperty(res, DAQ.value).next().asLiteral().getDouble();
            Observation obs = new Observation(res, date, value, metricType);
            if (!map.containsKey(metricType.toString())) {
                map.put(metricType.toString(), new ArrayList());
            }
            ((List)map.get(metricType.toString())).add(obs);
        }
        return map;
    }

    public static Map<String, Integer> getNumberOfMetricsInDimension() {
        HashMap<String, Integer> metricsPerDimension = new HashMap<String, Integer>();
        Model m = InternalModelConf.getFlatModel();
        String whereClause = "?dimensionURI a " + SPARQLHelper.toSPARQL(DAQ.Dimension) + " . ?dimensionURI ?hasMetricProperty ?metricURI . " + "?hasMetricProperty " + SPARQLHelper.toSPARQL((Resource)RDFS.subPropertyOf) + SPARQLHelper.toSPARQL((Resource)DAQ.hasMetric) + " .";
        String variables = "?dimensionURI COUNT(?metricURI) as ?count";
        String query = SPARQLHelper.SELECT_STATEMENT.replace("[variables]", variables).replace("[whereClauses]", whereClause);
        Query qry = QueryFactory.create((String)query);
        QueryExecution qe = QueryExecutionFactory.create((Query)qry, (Model)m);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            String dim = qs.get("dimensionURI").asResource().getURI();
            Integer count = qs.get("count").asLiteral().getInt();
            metricsPerDimension.put(dim, count);
        }
        return metricsPerDimension;
    }

    public static String getDimensionForMetric(Resource metricURI) {
        Model m = InternalModelConf.getFlatModel();
        String whereClause = "?dimension ?prop " + SPARQLHelper.toSPARQL(metricURI) + "?prop " + SPARQLHelper.toSPARQL((Resource)RDFS.subPropertyOf) + SPARQLHelper.toSPARQL((Resource)DAQ.hasMetric) + " .";
        String query = SPARQLHelper.SELECT_STATEMENT.replace("[variables]", "?dimension").replace("[whereClauses]", whereClause);
        Query qry = QueryFactory.create((String)query);
        QueryExecution qe = QueryExecutionFactory.create((Query)qry, (Model)m);
        ResultSet rs = qe.execSelect();
        String dim = "";
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            dim = qs.get("dimension").asResource().getURI();
        }
        return dim;
    }

    public static Map<String, Integer> getNumberOfDimensionsInCategory() {
        HashMap<String, Integer> dimensionPerCategory = new HashMap<String, Integer>();
        Model m = InternalModelConf.getFlatModel();
        String whereClause = "?categoryURI a " + SPARQLHelper.toSPARQL(DAQ.Category) + " . ?categoryURI ?hasDimensionProperty ?dimensionURI . " + "?hasMetricProperty " + SPARQLHelper.toSPARQL((Resource)RDFS.subPropertyOf) + SPARQLHelper.toSPARQL((Resource)DAQ.hasDimension) + " .";
        String variables = "?categoryURI COUNT(?dimensionURI) as ?count";
        String query = SPARQLHelper.SELECT_STATEMENT.replace("[variables]", variables).replace("[whereClauses]", whereClause);
        Query qry = QueryFactory.create((String)query);
        QueryExecution qe = QueryExecutionFactory.create((Query)qry, (Model)m);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            String cat = qs.get("categoryURI").asResource().getURI();
            Integer count = qs.get("count").asLiteral().getInt();
            dimensionPerCategory.put(cat, count);
        }
        return dimensionPerCategory;
    }

    public static String getCategoryForDimension(Resource dimensionURI) {
        Model m = InternalModelConf.getFlatModel();
        String whereClause = "?category ?prop " + SPARQLHelper.toSPARQL(dimensionURI) + "?prop " + SPARQLHelper.toSPARQL((Resource)RDFS.subPropertyOf) + SPARQLHelper.toSPARQL((Resource)DAQ.hasDimension) + " .";
        String query = SPARQLHelper.SELECT_STATEMENT.replace("[variables]", "?category").replace("[whereClauses]", whereClause);
        Query qry = QueryFactory.create((String)query);
        QueryExecution qe = QueryExecutionFactory.create((Query)qry, (Model)m);
        ResultSet rs = qe.execSelect();
        String cat = "";
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            cat = qs.get("category").asResource().getURI();
        }
        return cat;
    }

    public static List<String> getDimensionsInCategory(Resource categoryURI) {
        Model m = InternalModelConf.getFlatModel();
        String whereClause = SPARQLHelper.toSPARQL(categoryURI) + " ?prop ?dimensionURI" + "?prop " + SPARQLHelper.toSPARQL((Resource)RDFS.subPropertyOf) + SPARQLHelper.toSPARQL((Resource)DAQ.hasDimension) + " .";
        String query = SPARQLHelper.SELECT_STATEMENT.replace("[variables]", "?dimensionURI").replace("[whereClauses]", whereClause);
        Query qry = QueryFactory.create((String)query);
        QueryExecution qe = QueryExecutionFactory.create((Query)qry, (Model)m);
        ResultSet rs = qe.execSelect();
        ArrayList<String> dimensions = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            dimensions.add(qs.get("dimensionURI").asResource().getURI());
        }
        return dimensions;
    }

    private static Date toDateFormat(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS'Z'");
        return sdf.parse(date);
    }

    @Deprecated
    public static int getNumberOfMetricsInDataSet(Model m) {
        return DAQHelper.getNumberOfMetricsInDataSet(m, "");
    }

    @Deprecated
    public static int getNumberOfMetricsInDataSet(Model m, Resource dimensionOrCategoryURI, boolean isCategory) {
        String extraWhereClause = "";
        if (isCategory) {
            extraWhereClause = SPARQLHelper.toSPARQL(dimensionOrCategoryURI) + " ?hasDimensionProperty ?dimensionTypeURI . ";
            extraWhereClause = "?dimensionTypeURI  ?hasMetricProperty ?metricTypeURI .";
        } else {
            extraWhereClause = SPARQLHelper.toSPARQL(dimensionOrCategoryURI) + " ?hasMetricProperty ?metricTypeURI . ";
        }
        return DAQHelper.getNumberOfMetricsInDataSet(m, extraWhereClause);
    }

    @Deprecated
    private static int getNumberOfMetricsInDataSet(Model m, String extraSPARQLstmt) {
        Integer total = 0;
        Model internal = InternalModelConf.getFlatModel();
        DatasetImpl _temp = new DatasetImpl(internal);
        String _tempGraph = Commons.generateURI().toString();
        _temp.addNamedModel(_tempGraph, m);
        String whereDefaultGraphClause = "?metricTypeURI " + SPARQLHelper.toSPARQL((Resource)RDFS.subClassOf) + " " + SPARQLHelper.toSPARQL(DAQ.Metric) + " .";
        whereDefaultGraphClause = whereDefaultGraphClause + extraSPARQLstmt;
        String graphClause = "GRAPH <" + _tempGraph + "> { [where] }";
        String whereNamedGraphClause = "?typeURI " + SPARQLHelper.toSPARQL((Resource)RDF.type) + " ?metricTypeURI . ";
        graphClause = graphClause.replace("[where]", whereNamedGraphClause);
        String whereClause = whereDefaultGraphClause + graphClause;
        String query = SPARQLHelper.SELECT_STATEMENT.replace("[variables]", "(count(?typeURI) as ?count)").replace("[whereClauses]", whereClause);
        Query qry = QueryFactory.create((String)query);
        QueryExecution qe = QueryExecutionFactory.create((Query)qry, (Dataset)_temp);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            total = new Integer(soln.getResource("count").toString());
        }
        return total;
    }
}

