/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.web.visualise;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import de.unibonn.iai.eis.luzzu.operations.ranking.DatasetLoader;
import de.unibonn.iai.eis.luzzu.semantics.configuration.InternalModelConf;
import de.unibonn.iai.eis.luzzu.semantics.utilities.SPARQLHelper;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.DAQ;
import de.unibonn.iai.eis.luzzu.web.visualise.datatypes.DatasetObject;
import de.unibonn.iai.eis.luzzu.web.visualise.datatypes.MetricObject;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wizard {
    static final Logger logger = LoggerFactory.getLogger(Wizard.class);
    private static Dataset d = DatasetLoader.getInstance().getInternalDataset();

    public static String getAllDatasets() {
        String selectQuery = "SELECT DISTINCT ?dataset { ?x " + SPARQLHelper.toSPARQL((Resource)DAQ.computedOn) + " ?dataset . }";
        QueryExecution exec = QueryExecutionFactory.create((Query)QueryFactory.create((String)selectQuery), (Model)Wizard.getFlatModel());
        String json = "[";
        ResultSet set = exec.execSelect();
        while (set.hasNext()) {
            QuerySolution sol = set.next();
            json = json + "\"" + sol.get("dataset").asResource().toString() + "\",";
        }
        json = json.substring(0, json.length() - 1);
        json = json + "]";
        return json;
    }

    public static String getAllCommonDatasetsMetrics() {
        d.addNamedModel("urn:InternalModelConfig", InternalModelConf.getFlatModel());
        String selectQuery = "";
        URL url = Resources.getResource((String)"DatasetMetrics.sparql");
        try {
            selectQuery = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("Error: {}", (Object)e.getMessage());
        }
        QueryExecution exec = QueryExecutionFactory.create((Query)QueryFactory.create((String)selectQuery), (Model)Wizard.getFlatModel());
        HashMap<String, DatasetObject> datasetObjects = new HashMap<String, DatasetObject>();
        HashMap<String, MetricObject> metricObjects = new HashMap<String, MetricObject>();
        ResultSet set = exec.execSelect();
        while (set.hasNext()) {
            QuerySolution sol = set.next();
            String ds = sol.get("dataset").asResource().toString();
            String metricName = sol.get("metric_name").asLiteral().toString();
            String metric = sol.get("metric").asResource().toString();
            MetricObject mo = null;
            DatasetObject dso = null;
            if (datasetObjects.containsKey(ds)) {
                dso = (DatasetObject)datasetObjects.get(ds);
                if (metricObjects.containsKey(metric)) {
                    if (dso.getMetrics().contains(metric)) continue;
                    mo = (MetricObject)metricObjects.get(metric);
                    mo.getCommonDatasets().add(ds);
                    dso.getMetrics().add(mo);
                    continue;
                }
                mo = new MetricObject();
                mo.setName(metricName);
                mo.setUri(metric);
                mo.getCommonDatasets().add(ds);
                dso.getMetrics().add(mo);
                metricObjects.put(metric, mo);
                continue;
            }
            dso = new DatasetObject();
            dso.setName(ds);
            if (metricObjects.containsKey(metric)) {
                if (!dso.getMetrics().contains(metric)) {
                    mo = (MetricObject)metricObjects.get(metric);
                    mo.getCommonDatasets().add(ds);
                    dso.getMetrics().add(mo);
                }
            } else {
                mo = new MetricObject();
                mo.setName(metricName);
                mo.setUri(metric);
                mo.getCommonDatasets().add(ds);
                dso.getMetrics().add(mo);
                metricObjects.put(metric, mo);
            }
            datasetObjects.put(ds, dso);
        }
        String json = "{ \"metrics\" : [";
        for (MetricObject mo : metricObjects.values()) {
            if (mo.getCommonDatasets().size() <= 1) continue;
            ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
            try {
                json = json + ow.writeValueAsString((Object)mo) + ",";
            }
            catch (JsonProcessingException e) {
                logger.error("Error transforming to json : {}", (Object)e.getMessage());
            }
        }
        json = json.substring(0, json.length() - 1);
        json = json + "]}";
        return json;
    }

    public static String getAllDatasetsWithMultipleObservations() {
        d.addNamedModel("urn:InternalModelConfig", InternalModelConf.getFlatModel());
        String selectQuery = "";
        URL url = Resources.getResource((String)"DatasetsMultObs.sparql");
        try {
            selectQuery = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("Error: {}", (Object)e.getMessage());
        }
        Model m = Wizard.getFlatModel();
        QueryExecution exec = QueryExecutionFactory.create((Query)QueryFactory.create((String)selectQuery, (Syntax)Syntax.syntaxARQ), (Model)m);
        HashMap<String, DatasetObject> dsmap = new HashMap<String, DatasetObject>();
        ResultSet set = exec.execSelect();
        while (set.hasNext()) {
            QuerySolution sol = set.next();
            String dataset = sol.get("dataset").asResource().getURI();
            String metric_name = sol.get("metric_name").asLiteral().toString();
            String metric_uri = sol.get("metric").asResource().getURI();
            MetricObject mo = new MetricObject();
            mo.setName(metric_name);
            mo.setUri(metric_uri);
            if (dsmap.containsKey(dataset)) {
                ((DatasetObject)dsmap.get(dataset)).getMetrics().add(mo);
                continue;
            }
            DatasetObject dso = new DatasetObject();
            dso.setName(dataset);
            dso.getMetrics().add(mo);
            dsmap.put(dataset, dso);
        }
        String json = "{ \"datasets\" : [";
        for (DatasetObject dso : dsmap.values()) {
            ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
            try {
                json = json + ow.writeValueAsString((Object)dso) + ",";
            }
            catch (JsonProcessingException e) {
                logger.error("Error transforming to json : {}", (Object)e.getMessage());
            }
        }
        json = json.substring(0, json.length() - 1);
        json = json + "]}";
        return json;
    }

    private static Model getFlatModel() {
        Model m = ModelFactory.createDefaultModel();
        Iterator iter = d.listNames();
        while (iter.hasNext()) {
            m.add(d.getNamedModel((String)iter.next()));
        }
        m.add(d.getDefaultModel());
        return m;
    }
}

