/*
 * Decompiled with CFR 0.152.
 */
package de.unidue.ltl.evaluation.util.convert;

import de.unidue.ltl.evaluation.core.EvaluationData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DKProTcDataFormatConverter {
    public static EvaluationData<String> convertSingleLabelModeId2Outcome(File id2OutcomeFile) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(id2OutcomeFile), "utf-8"));
        reader.readLine();
        Map<String, String> map = DKProTcDataFormatConverter.buildMappingFromHeader(reader.readLine());
        EvaluationData data = new EvaluationData();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            String[] split = line.split("=");
            String docName = split[0];
            String values = split[1];
            String[] valSplit = values.split(";");
            String prediction = map.get(valSplit[0]);
            String gold = map.get(valSplit[1]);
            data.register((Object)gold, (Object)prediction, docName);
        }
        reader.close();
        return data;
    }

    public static EvaluationData<String> convertMultiLabelModeId2Outcome(File id2OutcomeFile) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(id2OutcomeFile), "utf-8"));
        reader.readLine();
        Map<String, String> map = DKProTcDataFormatConverter.buildMappingFromHeader(reader.readLine());
        EvaluationData data = new EvaluationData();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            String[] split = line.split("=");
            String docName = split[0];
            String values = split[1];
            String[] valSplit = values.split(";");
            Double threshold = Double.valueOf(valSplit[2]);
            String prediction = valSplit[0];
            List<String> mappedPred = DKProTcDataFormatConverter.convertMultiLabel(prediction.split(","), threshold, map);
            String gold = valSplit[1];
            List<String> mappedGold = DKProTcDataFormatConverter.convertMultiLabel(gold.split(","), threshold, map);
            data.registerMultiLabel(mappedGold, mappedPred, docName);
        }
        reader.close();
        return data;
    }

    public static EvaluationData<Integer> convertMultiLabelModeId2OutcomeUseInteger(File id2OutcomeFile) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(id2OutcomeFile), "utf-8"));
        reader.readLine();
        reader.readLine();
        EvaluationData data = new EvaluationData();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            String[] split = line.split("=");
            String docName = split[0];
            String values = split[1];
            String[] valSplit = values.split(";");
            Double threshold = Double.valueOf(valSplit[2]);
            String prediction = valSplit[0];
            List<Integer> mappedPred = DKProTcDataFormatConverter.convertMultiLabelToIntegerArray(prediction.split(","), threshold);
            String gold = valSplit[1];
            List<Integer> mappedGold = DKProTcDataFormatConverter.convertMultiLabelToIntegerArray(gold.split(","), threshold);
            data.registerMultiLabel(mappedGold, mappedPred, docName);
        }
        reader.close();
        return data;
    }

    private static List<Integer> convertMultiLabelToIntegerArray(String[] vals, Double threshold) throws ParseException {
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (int i = 0; i < vals.length; ++i) {
            if (Double.valueOf(vals[i]) >= threshold) {
                out.add(1);
                continue;
            }
            out.add(0);
        }
        return out;
    }

    private static List<String> convertMultiLabel(String[] vals, Double threshold, Map<String, String> map) {
        ArrayList<String> outLabels = new ArrayList<String>();
        for (int i = 0; i < vals.length; ++i) {
            if (!(Double.valueOf(vals[i]) >= threshold)) continue;
            outLabels.add(map.get("" + i));
        }
        return outLabels;
    }

    private static Map<String, String> buildMappingFromHeader(String header) {
        String[] split;
        header = header.replaceAll("#labels", "").trim();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : split = header.split(" ")) {
            int indexOf = entry.indexOf("=");
            String key = entry.substring(0, indexOf).trim();
            String val = entry.substring(indexOf + 1).trim();
            map.put(key, val);
        }
        return map;
    }

    public static EvaluationData<Double> convertRegressionModeId2Outcome(File id2OutcomeFile) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(id2OutcomeFile), "utf-8"));
        reader.readLine();
        reader.readLine();
        EvaluationData data = new EvaluationData();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            String[] split = line.split("=");
            String docName = split[0];
            String values = split[1];
            String[] valSplit = values.split(";");
            Double prediction = Double.valueOf(valSplit[0]);
            Double gold = Double.valueOf(valSplit[1]);
            data.register((Object)gold, (Object)prediction, docName);
        }
        reader.close();
        return data;
    }
}

