/*
 * Decompiled with CFR 0.152.
 */
package de.unidue.ltl.evaluation.util.transformation;

import de.unidue.ltl.evaluation.core.EvaluationData;
import de.unidue.ltl.evaluation.core.EvaluationEntry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class EvaluationTransformer {
    @SafeVarargs
    public static <T> EvaluationData<T> deleteLabels(EvaluationData<T> eval, T ... labels) {
        EvaluationData transformed = new EvaluationData();
        HashSet<T> labelSet = new HashSet<T>(Arrays.asList(labels));
        for (EvaluationEntry entry : eval) {
            if (labelSet.contains(entry.getGold()) || labelSet.contains(entry.getPredicted())) continue;
            transformed.register(entry.getGold(), entry.getPredicted());
        }
        return transformed;
    }

    public static <T> EvaluationData<T> changeGoldLabel(EvaluationData<T> data, Map<T, T> mapping) {
        EvaluationData transformed = new EvaluationData();
        for (EvaluationEntry entry : data) {
            if (mapping.containsKey(entry.getGold())) {
                transformed.register(mapping.get(entry.getGold()), entry.getPredicted());
                continue;
            }
            transformed.register(entry.getGold(), entry.getPredicted());
        }
        return transformed;
    }

    public static <T> EvaluationData<T> changePredictedLabel(EvaluationData<T> data, Map<T, T> mapping) {
        EvaluationData transformed = new EvaluationData();
        for (EvaluationEntry entry : data) {
            if (mapping.containsKey(entry.getPredicted())) {
                transformed.register(entry.getGold(), mapping.get(entry.getPredicted()));
                continue;
            }
            transformed.register(entry.getGold(), entry.getPredicted());
        }
        return transformed;
    }
}

