/*
 * Decompiled with CFR 0.152.
 */
package de.unidue.ltl.evaluation.visualization;

import de.unidue.ltl.evaluation.core.EvaluationEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EvaluationMetaData<T> {
    public static final String DEFAULT_NAME = "no-name-set";
    private List<T> labels;
    private Map<T, Integer> distributionsPerLabelPredicted;
    private Map<T, Integer> distributionsPerLabelGold;
    private long numberOfEntries;
    private String name;

    public EvaluationMetaData(String name, Iterable<EvaluationEntry<T>> data) {
        this.name = name;
        this.labels = this.getDistinctLabels(data);
        this.distributionsPerLabelPredicted = this.getDistributionsPerLabel(data, true);
        this.distributionsPerLabelGold = this.getDistributionsPerLabel(data, false);
        this.numberOfEntries = this.getEntryCount(data);
    }

    private long getEntryCount(Iterable<EvaluationEntry<T>> data) {
        int count = 0;
        Iterator<EvaluationEntry<T>> iterator = data.iterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    private List<T> getDistinctLabels(Iterable<EvaluationEntry<T>> data) {
        HashSet<Object> labels = new HashSet<Object>();
        for (EvaluationEntry<T> e : data) {
            labels.add(e.getGold());
            labels.add(e.getPredicted());
        }
        return new ArrayList(labels);
    }

    public String getStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name:\t" + this.name + System.lineSeparator());
        sb.append("Labels:\t" + this.labels + System.lineSeparator());
        sb.append("# of Instances:\t" + this.numberOfEntries + System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append("Distribution of Gold Labels:" + System.lineSeparator());
        sb.append("\tL : #" + System.lineSeparator());
        for (T key : this.distributionsPerLabelGold.keySet()) {
            sb.append("\t" + key + " : " + this.distributionsPerLabelGold.get(key) + System.lineSeparator());
        }
        sb.append("Distribution of Predicted Labels:" + System.lineSeparator());
        sb.append("\tL : #" + System.lineSeparator());
        for (T key : this.distributionsPerLabelPredicted.keySet()) {
            sb.append("\t" + key + " : " + this.distributionsPerLabelPredicted.get(key) + System.lineSeparator());
        }
        return sb.toString();
    }

    private Map<T, Integer> getDistributionsPerLabel(Iterable<EvaluationEntry<T>> data, boolean isPredicted) {
        HashMap<T, Integer> distributionsPerLabel = new HashMap<T, Integer>();
        for (T label : this.labels) {
            int count = this.getCount4label(data, label, isPredicted);
            distributionsPerLabel.put(label, count);
        }
        return distributionsPerLabel;
    }

    private int getCount4label(Iterable<EvaluationEntry<T>> entries, T label, boolean isPredicted) {
        int counter = 0;
        for (EvaluationEntry<T> entry : entries) {
            if (isPredicted) {
                if (!entry.getPredicted().equals(label)) continue;
                ++counter;
                continue;
            }
            if (!entry.getGold().equals(label)) continue;
            ++counter;
        }
        return counter;
    }

    public String getName() {
        if (this.name == null) {
            return DEFAULT_NAME;
        }
        return this.name;
    }

    public List<T> getLabels() {
        return this.labels;
    }

    public Map<T, Integer> getDistributionsPerLabelPredicted() {
        return this.distributionsPerLabelPredicted;
    }

    public Map<T, Integer> getDistributionsPerLabelGold() {
        return this.distributionsPerLabelGold;
    }

    public void setName(String name) {
        this.name = name;
    }
}

