/*
 * Decompiled with CFR 0.152.
 */
package de.unidue.ltl.evaluation.visualization;

import de.unidue.ltl.evaluation.visualization.EvaluationMetaData;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class MetaDataVisualizer<T> {
    static final String PREDICTED_FILE = "pieChart_predicted.jpeg";
    static final String GOLD_FILE = "pieChart_gold.jpeg";

    public static <T> File[] getPieChart(EvaluationMetaData<T> meta, String outputFolder) throws Exception {
        MetaDataVisualizer.getPieChart(meta, true, outputFolder);
        MetaDataVisualizer.getPieChart(meta, false, outputFolder);
        return new File[]{MetaDataVisualizer.getPieChart(meta, true, outputFolder), MetaDataVisualizer.getPieChart(meta, true, outputFolder)};
    }

    public static <T> File getPieChart(EvaluationMetaData<T> meta, boolean isPredicted, String outputFolder) throws Exception {
        DefaultPieDataset dataset = new DefaultPieDataset();
        if (isPredicted) {
            for (T label : meta.getDistributionsPerLabelPredicted().keySet()) {
                dataset.setValue((Comparable)((Object)String.valueOf(label)), (Number)meta.getDistributionsPerLabelPredicted().get(label));
            }
        } else {
            for (T label : meta.getDistributionsPerLabelGold().keySet()) {
                dataset.setValue((Comparable)((Object)String.valueOf(label)), (Number)meta.getDistributionsPerLabelGold().get(label));
            }
        }
        JFreeChart someChart = null;
        someChart = isPredicted ? ChartFactory.createPieChart((String)(meta.getName() + " predicted label distribution"), (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false) : ChartFactory.createPieChart((String)(meta.getName() + " gold label distribution"), (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        PiePlot plot4 = (PiePlot)someChart.getPlot();
        plot4.setSimpleLabels(true);
        StandardPieSectionLabelGenerator generator = new StandardPieSectionLabelGenerator("{0} = {2}", (NumberFormat)new DecimalFormat("0"), (NumberFormat)new DecimalFormat("0.00%"));
        plot4.setLabelGenerator((PieSectionLabelGenerator)generator);
        try {
            if (isPredicted) {
                File target = new File(outputFolder, PREDICTED_FILE);
                ChartUtilities.saveChartAsJPEG((File)target, (JFreeChart)someChart, (int)1200, (int)1000);
                return target;
            }
            File target = new File(outputFolder, GOLD_FILE);
            ChartUtilities.saveChartAsJPEG((File)target, (JFreeChart)someChart, (int)1200, (int)1000);
            return target;
        }
        catch (Exception e) {
            throw new Exception("Could not write chart to [" + outputFolder + "]");
        }
    }
}

