/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.column.BooleanColumn;
import de.unknownreality.dataframe.column.ByteColumn;
import de.unknownreality.dataframe.column.DoubleColumn;
import de.unknownreality.dataframe.column.FloatColumn;
import de.unknownreality.dataframe.column.IntegerColumn;
import de.unknownreality.dataframe.column.LongColumn;
import de.unknownreality.dataframe.column.ShortColumn;
import de.unknownreality.dataframe.column.StringColumn;
import java.util.HashMap;
import java.util.Map;

public class ColumnTypeMap {
    private static final Map<Class<?>, Class<? extends DataFrameColumn>> DEFAULT_COLUMN_TYPES = new HashMap();
    private final Map<Class<?>, Class<? extends DataFrameColumn>> columnTypesMap = new HashMap();

    private ColumnTypeMap() {
        this.columnTypesMap.putAll(DEFAULT_COLUMN_TYPES);
    }

    public <T extends Comparable<T>, C extends DataFrameColumn<T, C>> Class<C> getColumnType(Class<T> type) {
        Class<? extends DataFrameColumn> columnType = this.columnTypesMap.get(type);
        if (columnType == null) {
            return null;
        }
        return columnType;
    }

    public <T extends Comparable<T>, C extends DataFrameColumn<T, C>> ColumnTypeMap addType(Class<T> type, Class<C> columnType) {
        this.columnTypesMap.put(type, columnType);
        return this;
    }

    public static ColumnTypeMap create() {
        return new ColumnTypeMap();
    }

    static {
        DEFAULT_COLUMN_TYPES.put(String.class, StringColumn.class);
        DEFAULT_COLUMN_TYPES.put(Double.class, DoubleColumn.class);
        DEFAULT_COLUMN_TYPES.put(Integer.class, IntegerColumn.class);
        DEFAULT_COLUMN_TYPES.put(Float.class, FloatColumn.class);
        DEFAULT_COLUMN_TYPES.put(Long.class, LongColumn.class);
        DEFAULT_COLUMN_TYPES.put(Boolean.class, BooleanColumn.class);
        DEFAULT_COLUMN_TYPES.put(Short.class, ShortColumn.class);
        DEFAULT_COLUMN_TYPES.put(Byte.class, ByteColumn.class);
    }
}

