/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.ColumnAppender;
import de.unknownreality.dataframe.ColumnTypeMap;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameException;
import de.unknownreality.dataframe.DataFrameHeader;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.column.BooleanColumn;
import de.unknownreality.dataframe.column.ByteColumn;
import de.unknownreality.dataframe.column.DoubleColumn;
import de.unknownreality.dataframe.column.FloatColumn;
import de.unknownreality.dataframe.column.IntegerColumn;
import de.unknownreality.dataframe.column.LongColumn;
import de.unknownreality.dataframe.column.NumberColumn;
import de.unknownreality.dataframe.column.ShortColumn;
import de.unknownreality.dataframe.column.StringColumn;
import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.common.mapping.DataMapper;
import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.filter.compile.PredicateCompiler;
import de.unknownreality.dataframe.group.DataGrouping;
import de.unknownreality.dataframe.group.GroupUtil;
import de.unknownreality.dataframe.index.Indices;
import de.unknownreality.dataframe.join.JoinColumn;
import de.unknownreality.dataframe.join.JoinUtil;
import de.unknownreality.dataframe.join.JoinedDataFrame;
import de.unknownreality.dataframe.sort.RowColumnComparator;
import de.unknownreality.dataframe.sort.SortColumn;
import de.unknownreality.dataframe.transform.DataFrameTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFrame
implements DataContainer<DataFrameHeader, DataRow> {
    private static final Logger log = LoggerFactory.getLogger(DataFrame.class);
    public static final String PRIMARY_INDEX_NAME = "primaryKey";
    private int size;
    private final Map<String, DataFrameColumn> columnsMap = new LinkedHashMap<String, DataFrameColumn>();
    private final LinkedHashSet<DataFrameColumn> columnList = new LinkedHashSet();
    private DataFrameHeader header = new DataFrameHeader();
    private final Indices indices = new Indices(this);

    public DataFrame() {
    }

    public DataFrame(DataFrameHeader header, Collection<DataRow> rows) {
        this.set(header, rows);
    }

    public DataFrame setPrimaryKey(String ... colNames) {
        DataFrameColumn[] columns = new DataFrameColumn[colNames.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.getColumn(colNames[i]);
        }
        return this.setPrimaryKey(columns);
    }

    public DataFrame setPrimaryKey(DataFrameColumn ... cols) {
        this.indices.setPrimaryKey(cols);
        return this;
    }

    public DataFrame removePrimaryKey() {
        this.indices.removeIndex(PRIMARY_INDEX_NAME);
        return this;
    }

    public DataFrame removeIndex(String name) {
        this.indices.removeIndex(name);
        return this;
    }

    public DataFrame renameColumn(String name, String newName) {
        DataFrameColumn column = this.columnsMap.get(name);
        if (column == null) {
            return this;
        }
        this.header.rename(name, newName);
        column.setName(newName);
        this.columnsMap.remove(name);
        this.columnsMap.put(newName, column);
        return this;
    }

    public DataFrame addColumn(DataFrameColumn column) {
        if (!this.columnList.isEmpty() && column.size() != this.size) {
            throw new DataFrameRuntimeException("column lengths must be equal");
        }
        this.columnList.add(column);
        if (column.getDataFrame() != null && column.getDataFrame() != this) {
            throw new DataFrameRuntimeException("column can not be added to multiple data frames. use column.copy() first");
        }
        if (this.columnList.size() == 1) {
            this.size = column.size();
        }
        try {
            column.setDataFrame(this);
        }
        catch (DataFrameException e) {
            throw new DataFrameRuntimeException("error adding column", e);
        }
        this.header.add(column.getName(), column.getClass(), column.getType());
        this.columnsMap.put(column.getName(), column);
        return this;
    }

    public <T extends Comparable<T>> DataFrame addColumn(Class<T> type, String name) {
        return this.addColumn(type, name, ColumnTypeMap.create());
    }

    public <T extends Comparable<T>> DataFrame addColumn(Class<T> type, String name, ColumnTypeMap columnTypeMap) {
        return this.addColumn(type, name, columnTypeMap, null);
    }

    public <T extends Comparable<T>, C extends DataFrameColumn<T, C>> DataFrame addColumn(Class<T> type, String name, ColumnTypeMap columnTypeMap, ColumnAppender<T> appender) {
        Class columnType = columnTypeMap.getColumnType(type);
        if (columnType == null) {
            throw new DataFrameRuntimeException(String.format("no  column type found for %s", type.getName()));
        }
        return this.addColumn(columnType, name, appender);
    }

    public <T extends Comparable<T>, C extends DataFrameColumn<T, C>> DataFrame addColumn(Class<C> type, String name, ColumnAppender<T> appender) {
        try {
            DataFrameColumn col = (DataFrameColumn)type.newInstance();
            col.setName(name);
            if (appender != null) {
                for (DataRow row : this) {
                    T val = appender.createRowValue(row);
                    if (val == null || val == Values.NA) {
                        col.doAppendNA();
                        continue;
                    }
                    col.doAppend(val);
                }
            } else {
                for (int i = 0; i < this.size(); ++i) {
                    col.doAppendNA();
                }
            }
            this.addColumn(col);
        }
        catch (InstantiationException e) {
            log.error("error creating instance of column [{}], empty constructor required", type, (Object)e);
            throw new DataFrameRuntimeException(String.format("error creating instance of column [%s], empty constructor required", type), e);
        }
        catch (IllegalAccessException e) {
            throw new DataFrameRuntimeException(String.format("error creating instance of column [%s], empty constructor required", type), e);
        }
        return this;
    }

    public DataFrame addColumns(Collection<DataFrameColumn> columns) {
        for (DataFrameColumn column : columns) {
            this.addColumn(column);
        }
        return this;
    }

    public DataFrame addColumns(DataFrameColumn ... columns) {
        for (DataFrameColumn column : columns) {
            this.addColumn(column);
        }
        return this;
    }

    public DataFrame append(Comparable ... values) {
        if (values.length != this.columnList.size()) {
            throw new DataFrameRuntimeException("value for each column required");
        }
        int i = 0;
        for (DataFrameColumn column : this.columnList) {
            if (values[i] != null && !column.getType().isAssignableFrom(values[i].getClass())) {
                throw new DataFrameRuntimeException(String.format("value %d has wrong type (%s != %s)", i, values[i].getClass().getName(), column.getType().getName()));
            }
            ++i;
        }
        i = 0;
        for (DataFrameColumn column : this.columnList) {
            column.startDataFrameAppend();
            Comparable value = values[i];
            if (value == null || value == Values.NA) {
                column.appendNA();
            } else {
                column.append(value);
            }
            column.endDataFrameAppend();
            ++i;
        }
        ++this.size;
        this.indices.update(this.getRow(this.size - 1));
        return this;
    }

    public DataFrame append(DataRow row) {
        for (String h : this.header) {
            DataFrameColumn column = this.columnsMap.get(h);
            column.startDataFrameAppend();
            if (row.isNA(h)) {
                column.appendNA();
            } else {
                column.append((Comparable)row.get(h));
            }
            column.endDataFrameAppend();
        }
        ++this.size;
        this.indices.update(this.getRow(this.size - 1));
        return this;
    }

    public DataFrame update(DataRow dataRow) {
        for (String h : this.header) {
            DataFrameColumn column = this.getColumn(h);
            Comparable newValue = (Comparable)dataRow.get(h);
            if (newValue == null) continue;
            if (newValue == Values.NA) {
                column.setNA(dataRow.getIndex());
                continue;
            }
            column.set(dataRow.getIndex(), newValue);
        }
        return this;
    }

    public DataFrame set(Collection<DataRow> rows) {
        this.size = 0;
        this.indices.clearValues();
        for (DataFrameColumn column : this.columnsMap.values()) {
            column.clear();
        }
        for (DataRow row : rows) {
            this.append(row);
        }
        return this;
    }

    public DataFrame set(DataFrameHeader header, Collection<DataRow> rows) {
        return this.set(header, rows, null);
    }

    private DataFrame set(DataFrameHeader header, Collection<DataRow> rows, Indices indices) {
        this.header = header;
        this.columnsMap.clear();
        this.columnList.clear();
        this.indices.clearValues();
        for (String h : header) {
            try {
                DataFrameColumn instance = header.getColumnType(h).newInstance();
                instance.setName(h);
                this.columnsMap.put(h, instance);
                this.columnList.add(instance);
                instance.setDataFrame(this);
            }
            catch (DataFrameException | IllegalAccessException | InstantiationException e) {
                log.error("error creating column instance", (Throwable)e);
                throw new DataFrameRuntimeException("error creating column instance", e);
            }
        }
        if (indices != null) {
            indices.copyTo(this);
        }
        this.set(rows);
        return this;
    }

    public DataFrame removeColumn(String header) {
        DataFrameColumn column = this.getColumn(header);
        if (column == null) {
            log.error("error column not found {}", (Object)header);
            return this;
        }
        return this.removeColumn(column);
    }

    public DataFrame removeColumn(DataFrameColumn column) {
        try {
            column.setDataFrame(null);
        }
        catch (DataFrameException e) {
            throw new DataFrameRuntimeException("error removing column", e);
        }
        this.header.remove(column.getName());
        this.indices.removeColumn(column);
        this.columnsMap.remove(column.getName());
        this.columnList.remove(column);
        return this;
    }

    public DataFrame sort(SortColumn ... columns) {
        List<DataRow> rows = this.getRows(0, this.size);
        Collections.sort(rows, new RowColumnComparator(columns));
        this.set(rows);
        return this;
    }

    public DataFrame sort(Comparator<DataRow> comp) {
        List<DataRow> rows = this.getRows(0, this.size);
        Collections.sort(rows, comp);
        this.set(rows);
        return this;
    }

    public DataFrame sort(String name) {
        return this.sort(name, SortColumn.Direction.Ascending);
    }

    public DataFrame sort(String name, SortColumn.Direction dir) {
        List<DataRow> rows = this.getRows(0, this.size);
        Collections.sort(rows, new RowColumnComparator(new SortColumn[]{new SortColumn(name, dir)}));
        this.set(rows);
        return this;
    }

    public DataFrame shuffle() {
        List<DataRow> rows = this.getRows(0, this.size);
        Collections.shuffle(rows);
        this.set(rows);
        return this;
    }

    public DataFrame select(String colName, Comparable value) {
        return this.select(FilterPredicate.eq(colName, value));
    }

    public DataRow selectFirst(String colName, Comparable value) {
        return this.selectFirst(FilterPredicate.eq(colName, value));
    }

    public DataRow selectFirst(String predicateString) {
        return this.selectFirst(FilterPredicate.compile(predicateString));
    }

    public DataRow selectFirst(FilterPredicate predicate) {
        for (DataRow row : this) {
            if (!predicate.valid(row)) continue;
            return row;
        }
        return null;
    }

    public DataFrame select(FilterPredicate predicate) {
        List<DataRow> rows = this.selectRows(predicate);
        DataFrame df = new DataFrame();
        df.set(this.header.copy(), rows, this.indices);
        return df;
    }

    public DataFrame select(String predicateString) {
        return this.select(PredicateCompiler.compile(predicateString));
    }

    @Deprecated
    public DataFrame find(String colName, Comparable value) {
        return this.select(colName, value);
    }

    @Deprecated
    public DataRow findFirst(String colName, Comparable value) {
        return this.selectFirst(colName, value);
    }

    @Deprecated
    public DataRow findFirst(FilterPredicate predicate) {
        return this.selectFirst(predicate);
    }

    public DataFrame filter(String predicateString) {
        this.filter(FilterPredicate.compile(predicateString));
        return this;
    }

    public DataFrame filter(FilterPredicate predicate) {
        this.set(this.selectRows(predicate));
        return this;
    }

    @Deprecated
    public DataFrame find(FilterPredicate predicate) {
        return this.select(predicate);
    }

    public List<DataRow> selectRows(String predicateString) {
        return this.selectRows(FilterPredicate.compile(predicateString));
    }

    public List<DataRow> selectRows(FilterPredicate predicate) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (DataRow row : this) {
            if (!predicate.valid(row)) continue;
            rows.add(row);
        }
        return rows;
    }

    @Deprecated
    public List<DataRow> findRows(FilterPredicate predicate) {
        return this.selectRows(predicate);
    }

    public DataFrame transform(DataFrameTransform transformer) {
        return transformer.transform(this);
    }

    public DataRow findByPrimaryKey(Comparable ... keyValues) {
        Integer index = this.indices.findByPrimaryKey(keyValues);
        if (index == null || index < 0) {
            return null;
        }
        return this.getRow(index);
    }

    public DataFrame reverse() {
        for (DataFrameColumn col : this.columnList) {
            col.doReverse();
        }
        return this;
    }

    public DataFrame addIndex(String indexName, String ... columnNames) {
        DataFrameColumn[] columns = new DataFrameColumn[columnNames.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.getColumn(columnNames[i]);
        }
        return this.addIndex(indexName, columns);
    }

    public DataFrame addIndex(String indexName, DataFrameColumn ... columns) {
        this.indices.addIndex(indexName, columns);
        return this;
    }

    public int size() {
        return this.size;
    }

    public DataFrame subset(int from, int to) {
        this.set(this.getRows(from, to));
        return this;
    }

    public DataFrame createSubset(int from, int to) {
        DataFrame newFrame = new DataFrame();
        newFrame.set(this.header.copy(), this.getRows(from, to), this.indices);
        return newFrame;
    }

    public List<DataRow> getRows(int from, int to) {
        ArrayList<DataRow> rows = new ArrayList<DataRow>();
        for (int i = from; i < to; ++i) {
            rows.add(this.getRow(i));
        }
        return rows;
    }

    public List<DataRow> getRows() {
        return this.getRows(0, this.size);
    }

    @Override
    public DataFrameHeader getHeader() {
        return this.header;
    }

    public DataFrame concat(DataFrame other) {
        if (!this.header.equals(other.getHeader())) {
            throw new DataFrameRuntimeException("data frames not compatible");
        }
        for (DataRow row : other) {
            this.append(row);
        }
        return this;
    }

    public DataFrame concat(Collection<DataFrame> dataFrames) {
        for (DataFrame dataFrame : dataFrames) {
            if (!this.header.equals(dataFrame.getHeader())) {
                throw new DataFrameRuntimeException("data frames not compatible");
            }
            for (DataRow row : dataFrame) {
                this.append(row);
            }
        }
        return this;
    }

    public DataFrame concat(DataFrame ... dataFrames) {
        return this.concat(Arrays.asList(dataFrames));
    }

    public boolean isCompatible(DataFrame input) {
        return this.header.equals(input.getHeader());
    }

    public DataRow getRow(int i) {
        return new DataRow(this.header, this.getRowValues(i), i);
    }

    public Comparable[] getRowValues(int i) {
        if (i >= this.size) {
            throw new DataFrameRuntimeException("index out of bounds");
        }
        Comparable[] values = new Comparable[this.columnList.size()];
        int j = 0;
        for (DataFrameColumn column : this.columnList) {
            if (column.isNA(i)) {
                values[j++] = Values.NA;
                continue;
            }
            values[j++] = column.get(i);
        }
        return values;
    }

    public Collection<String> getColumnNames() {
        return new ArrayList<String>(this.columnsMap.keySet());
    }

    public DataFrameColumn getColumn(String name) {
        return this.columnsMap.get(name);
    }

    public <T extends DataFrameColumn> T getColumn(String name, Class<T> cl) {
        DataFrameColumn column = this.columnsMap.get(name);
        if (column == null) {
            throw new DataFrameRuntimeException(String.format("column '%s' not found", name));
        }
        if (!cl.isInstance(column)) {
            throw new DataFrameRuntimeException(String.format("column '%s' has wrong type", name));
        }
        return (T)((DataFrameColumn)cl.cast(column));
    }

    public NumberColumn getNumberColumn(String name) {
        return this.getColumn(name, NumberColumn.class);
    }

    public StringColumn getStringColumn(String name) {
        return this.getColumn(name, StringColumn.class);
    }

    public DoubleColumn getDoubleColumn(String name) {
        return this.getColumn(name, DoubleColumn.class);
    }

    public IntegerColumn getIntegerColumn(String name) {
        return this.getColumn(name, IntegerColumn.class);
    }

    public FloatColumn getFloatColumn(String name) {
        return this.getColumn(name, FloatColumn.class);
    }

    public BooleanColumn getBooleanColumn(String name) {
        return this.getColumn(name, BooleanColumn.class);
    }

    public ByteColumn getByteColumn(String name) {
        return this.getColumn(name, ByteColumn.class);
    }

    public LongColumn getLongColumn(String name) {
        return this.getColumn(name, LongColumn.class);
    }

    public ShortColumn getShortColumn(String name) {
        return this.getColumn(name, ShortColumn.class);
    }

    public DataGrouping groupBy(String ... column) {
        return GroupUtil.groupBy(this, column);
    }

    public JoinedDataFrame joinLeft(DataFrame dataFrame, String ... joinColumns) {
        JoinColumn[] joinColumnsArray = new JoinColumn[joinColumns.length];
        for (int i = 0; i < joinColumns.length; ++i) {
            joinColumnsArray[i] = new JoinColumn(joinColumns[i]);
        }
        return this.joinLeft(dataFrame, joinColumnsArray);
    }

    public JoinedDataFrame joinLeft(DataFrame dataFrame, JoinColumn ... joinColumns) {
        return JoinUtil.leftJoin(this, dataFrame, joinColumns);
    }

    public JoinedDataFrame joinLeft(DataFrame dataFrame, String suffixA, String suffixB, JoinColumn ... joinColumns) {
        return JoinUtil.leftJoin(this, dataFrame, suffixA, suffixB, joinColumns);
    }

    public JoinedDataFrame joinRight(DataFrame dataFrame, String ... joinColumns) {
        JoinColumn[] joinColumnsArray = new JoinColumn[joinColumns.length];
        for (int i = 0; i < joinColumns.length; ++i) {
            joinColumnsArray[i] = new JoinColumn(joinColumns[i]);
        }
        return this.joinRight(dataFrame, joinColumnsArray);
    }

    public JoinedDataFrame joinRight(DataFrame dataFrame, JoinColumn ... joinColumns) {
        return JoinUtil.rightJoin(this, dataFrame, joinColumns);
    }

    public JoinedDataFrame joinRight(DataFrame dataFrame, String suffixA, String suffixB, JoinColumn ... joinColumns) {
        return JoinUtil.rightJoin(this, dataFrame, suffixA, suffixB, joinColumns);
    }

    public JoinedDataFrame joinInner(DataFrame dataFrame, String ... joinColumns) {
        JoinColumn[] joinColumnsArray = new JoinColumn[joinColumns.length];
        for (int i = 0; i < joinColumns.length; ++i) {
            joinColumnsArray[i] = new JoinColumn(joinColumns[i]);
        }
        return this.joinInner(dataFrame, joinColumnsArray);
    }

    public JoinedDataFrame joinInner(DataFrame dataFrame, JoinColumn ... joinColumns) {
        return JoinUtil.innerJoin(this, dataFrame, joinColumns);
    }

    public JoinedDataFrame joinInner(DataFrame dataFrame, String suffixA, String suffixB, JoinColumn ... joinColumns) {
        return JoinUtil.innerJoin(this, dataFrame, suffixA, suffixB, joinColumns);
    }

    public DataFrame copy() {
        List<DataRow> rows = this.getRows(0, this.size);
        DataFrame copy = new DataFrame();
        copy.set(this.header.copy(), rows, this.indices);
        return copy;
    }

    public boolean containsColumn(DataFrameColumn column) {
        return this.columnList.contains(column);
    }

    protected void notifyColumnValueChanged(DataFrameColumn column, int index, Comparable value) {
        if (this.indices.isIndexColumn(column)) {
            this.indices.updateValue(column, this.getRow(index));
        }
    }

    protected void notifyColumnChanged(DataFrameColumn column) {
        if (this.indices.isIndexColumn(column)) {
            this.indices.updateColumn(column);
        }
    }

    public boolean isIndexColumn(DataFrameColumn column) {
        return this.indices.isIndexColumn(column);
    }

    public List<DataRow> findByIndex(String name, Comparable ... values) {
        Collection<Integer> rowIndices = this.indices.find(name, values);
        if (!rowIndices.isEmpty()) {
            ArrayList<DataRow> rows = new ArrayList<DataRow>();
            for (Integer i : rowIndices) {
                rows.add(this.getRow(i));
            }
            return rows;
        }
        return new ArrayList<DataRow>(0);
    }

    public DataRow findFirstByIndex(String name, Comparable ... values) {
        Integer idx = this.indices.findFirst(name, values);
        return idx == null ? null : this.getRow(idx);
    }

    public Collection<DataFrameColumn> getColumns() {
        return this.columnList;
    }

    protected Indices getIndices() {
        return this.indices;
    }

    @Override
    public <T> List<T> map(Class<T> cl) {
        return DataMapper.map(this, cl);
    }

    @Override
    public Iterator<DataRow> iterator() {
        return new Iterator<DataRow>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DataFrame.this.size;
            }

            @Override
            public DataRow next() {
                if (this.index == DataFrame.this.size()) {
                    throw new NoSuchElementException("index out of bounds");
                }
                return DataFrame.this.getRow(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported for data frames");
            }
        };
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DataFrame)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        DataFrame d = (DataFrame)o;
        if (this.size() != d.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.getRow(i).equals(d.getRow(i))) continue;
            return false;
        }
        return true;
    }
}

