/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameConverter;
import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.filter.FilterPredicate;
import java.util.LinkedHashMap;

public class DataFrameBuilder {
    private final LinkedHashMap<String, DataFrameColumn> columns = new LinkedHashMap();
    private final DataContainer<?, ?> dataContainer;
    private FilterPredicate filterPredicate = FilterPredicate.EMPTY_FILTER;

    private DataFrameBuilder(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    public static DataFrameBuilder create(DataContainer dataContainer) {
        return new DataFrameBuilder(dataContainer);
    }

    public DataFrameBuilder addColumn(DataFrameColumn column) {
        this.columns.put(column.getName(), column);
        return this;
    }

    public DataFrameBuilder withFilterPredicate(FilterPredicate predicate) {
        this.filterPredicate = predicate;
        return this;
    }

    public DataFrameBuilder addColumn(String header, DataFrameColumn column) {
        this.columns.put(header, column);
        return this;
    }

    public DataFrame build() {
        return DataFrameConverter.fromDataContainer(this.dataContainer, this.columns, this.filterPredicate);
    }
}

