/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.filter.FilterPredicate;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFrameConverter {
    private static final Logger log = LoggerFactory.getLogger(DataFrameConverter.class);

    private DataFrameConverter() {
    }

    public static DataFrame fromDataContainer(DataContainer<?, ?> reader, Map<String, DataFrameColumn> columns, FilterPredicate filterPredicate) {
        if (reader.getHeader().size() == 0) {
            DataFrame dataFrame = new DataFrame();
            for (DataFrameColumn column : columns.values()) {
                dataFrame.addColumn(column);
            }
            return dataFrame;
        }
        int[] colIndices = new int[columns.size()];
        int i = 0;
        for (String h : columns.keySet()) {
            colIndices[i] = reader.getHeader().getIndex((String)h);
            ++i;
        }
        DataFrame dataFrame = new DataFrame();
        for (DataFrameColumn column : columns.values()) {
            dataFrame.addColumn(column);
        }
        for (Row row : reader) {
            i = -1;
            Comparable[] rowValues = new Comparable[columns.size()];
            for (Map.Entry<String, DataFrameColumn> columnEntry : columns.entrySet()) {
                ++i;
                Object val = null;
                try {
                    val = columnEntry.getValue().getValueFromRow(row, colIndices[i]);
                }
                catch (Exception e) {
                    log.warn("error parsing value ({}), NA added", (Object)e.getMessage());
                }
                if (val == null || Values.NA.isNA(val) || val instanceof String && ("".equals(val.toString()) || "null".equals(val.toString()))) {
                    rowValues[i] = Values.NA;
                    continue;
                }
                rowValues[i] = val;
            }
            DataRow dataRow = new DataRow(dataFrame.getHeader(), rowValues, dataFrame.size() - 1);
            if (!filterPredicate.valid(dataRow)) continue;
            dataFrame.append(dataRow);
        }
        return dataFrame;
    }

    public static DataFrame fromDataContainer(DataContainer<?, ?> reader, Map<String, DataFrameColumn> columns) {
        return DataFrameConverter.fromDataContainer(reader, columns, FilterPredicate.EMPTY_FILTER);
    }
}

