/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameConverter;
import de.unknownreality.dataframe.DataFrameException;
import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.common.ReaderBuilder;
import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.meta.DataFrameMeta;
import de.unknownreality.dataframe.meta.DataFrameMetaReader;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

public class DataFrameLoader {
    private DataFrameLoader() {
    }

    public static DataFrame load(File file, FilterPredicate filterPredicate) throws DataFrameException {
        File dataFile;
        File metaFile;
        String ext = ".dfm";
        String filePath = file.getAbsolutePath();
        if (file.getName().endsWith(ext)) {
            metaFile = file;
            dataFile = new File(filePath.substring(0, filePath.length() - ext.length()));
        } else {
            dataFile = file;
            metaFile = new File(filePath + ext);
        }
        return DataFrameLoader.load(dataFile, metaFile, filterPredicate);
    }

    public static DataFrame load(File file) throws DataFrameException {
        return DataFrameLoader.load(file, FilterPredicate.EMPTY_FILTER);
    }

    public static DataFrame load(File file, File metaFile, FilterPredicate filterPredicate) throws DataFrameException {
        ReaderBuilder readerBuilder;
        if (!file.exists()) {
            throw new DataFrameException(String.format("file not found %s", file.getAbsolutePath()));
        }
        if (!metaFile.exists()) {
            throw new DataFrameException(String.format("meta file not found %s", metaFile.getAbsolutePath()));
        }
        DataFrameMeta dataFrameMeta = DataFrameMetaReader.read(metaFile);
        try {
            readerBuilder = dataFrameMeta.getReaderBuilderClass().newInstance();
        }
        catch (Exception e) {
            throw new DataFrameException("error creating readerBuilder instance", e);
        }
        try {
            readerBuilder.loadAttributes(dataFrameMeta.getAttributes());
        }
        catch (Exception e) {
            throw new DataFrameException("error loading readerBuilder attributes", e);
        }
        Map<String, DataFrameColumn> columns = DataFrameLoader.createColumns(dataFrameMeta);
        DataContainer fileContainer = readerBuilder.fromFile(file);
        Map<String, DataFrameColumn> convertedColumns = DataFrameLoader.convertColumns(columns, fileContainer);
        return DataFrameConverter.fromDataContainer(fileContainer, convertedColumns, filterPredicate);
    }

    public static DataFrame load(File file, File metaFile) throws DataFrameException {
        return DataFrameLoader.load(file, metaFile, FilterPredicate.EMPTY_FILTER);
    }

    public static DataFrame loadResource(String path, String metaPath, ClassLoader classLoader, FilterPredicate filterPredicate) throws DataFrameException {
        ReaderBuilder readerBuilder;
        DataFrameMeta dataFrameMeta = DataFrameMetaReader.read(classLoader.getResourceAsStream(metaPath));
        try {
            readerBuilder = dataFrameMeta.getReaderBuilderClass().newInstance();
        }
        catch (Exception e) {
            throw new DataFrameException("error creating readerBuilder instance", e);
        }
        try {
            readerBuilder.loadAttributes(dataFrameMeta.getAttributes());
        }
        catch (Exception e) {
            throw new DataFrameException("error loading readerBuilder attributes", e);
        }
        Map<String, DataFrameColumn> columns = DataFrameLoader.createColumns(dataFrameMeta);
        DataContainer fileContainer = readerBuilder.fromResource(path, classLoader);
        Map<String, DataFrameColumn> convertedColumns = DataFrameLoader.convertColumns(columns, fileContainer);
        return DataFrameConverter.fromDataContainer(fileContainer, convertedColumns, filterPredicate);
    }

    public static DataFrame loadResource(String path, String metaPath, ClassLoader classLoader) throws DataFrameException {
        return DataFrameLoader.loadResource(path, metaPath, classLoader, FilterPredicate.EMPTY_FILTER);
    }

    private static Map<String, DataFrameColumn> convertColumns(Map<String, DataFrameColumn> columns, DataContainer fileContainer) throws DataFrameException {
        int i = 0;
        if (fileContainer.getHeader().size() == 0) {
            return columns;
        }
        LinkedHashMap<String, DataFrameColumn> convertedColumns = new LinkedHashMap<String, DataFrameColumn>();
        for (Map.Entry<String, DataFrameColumn> entry : columns.entrySet()) {
            if (i == fileContainer.getHeader().size()) {
                throw new DataFrameException("columns count not matching meta file");
            }
            convertedColumns.put(fileContainer.getHeader().get(i).toString(), entry.getValue());
            ++i;
        }
        return convertedColumns;
    }

    public static Map<String, DataFrameColumn> createColumns(DataFrameMeta dataFrameMeta) throws DataFrameException {
        LinkedHashMap<String, DataFrameColumn> columns = new LinkedHashMap<String, DataFrameColumn>();
        for (Map.Entry<String, Class<? extends DataFrameColumn>> entry : dataFrameMeta.getColumns().entrySet()) {
            DataFrameColumn column;
            String name = entry.getKey();
            Class<? extends DataFrameColumn> columnType = entry.getValue();
            try {
                column = columnType.newInstance();
            }
            catch (Exception e) {
                throw new DataFrameException("error creating column instance", e);
            }
            column.setName(name);
            columns.put(name, column);
        }
        return columns;
    }
}

