/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.column;

import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.MapFunction;
import de.unknownreality.dataframe.Values;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class BasicColumn<T extends Comparable<T>, C extends BasicColumn<T, C>>
extends DataFrameColumn<T, C> {
    public static final double GROW_FACTOR = 1.6;
    public static final int INIT_SIZE = 128;
    private int size = 0;
    protected T[] values;

    public BasicColumn(String name) {
        this.size = 0;
        this.setName(name);
        this.values = (Comparable[])Array.newInstance(this.getType(), 128);
    }

    public BasicColumn() {
        this(null);
    }

    public BasicColumn(String name, T[] values) {
        this.values = values;
        this.setName(name);
        this.size = values.length;
    }

    @Override
    protected void doSort(Comparator<T> comparator) {
        Arrays.sort(this.values, 0, this.size(), comparator);
    }

    @Override
    protected void doSort() {
        Arrays.sort(this.values, 0, this.size());
    }

    @Override
    protected final void doSet(int index, T value) {
        if (value == Values.NA) {
            this.doAppendNA();
            return;
        }
        this.values[index] = value;
    }

    @Override
    protected void doMap(MapFunction<T> mapFunction) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.isNA(i)) continue;
            this.values[i] = (Comparable)mapFunction.map(this.values[i]);
        }
    }

    @Override
    protected void doReverse() {
        for (int i = 0; i < this.size() / 2; ++i) {
            T temp = this.values[i];
            this.values[i] = this.values[this.size() - i - 1];
            this.values[this.size() - i - 1] = temp;
        }
    }

    @Override
    public T get(int index) {
        return this.values[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(T o) {
        return Arrays.asList(this.values).contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported by this iterator");
            }

            @Override
            public boolean hasNext() {
                return this.index < BasicColumn.this.size();
            }

            @Override
            public T next() {
                if (this.index >= BasicColumn.this.values.length) {
                    throw new NoSuchElementException(String.format("element not found: index out of bounds %s >= %s]", this.index, BasicColumn.this.values.length));
                }
                return BasicColumn.this.values[this.index++];
            }
        };
    }

    public Set<T> uniq() {
        return new HashSet<T>(Arrays.asList(this.values));
    }

    @Override
    public Comparable[] toArray() {
        return (Comparable[])Arrays.copyOf(this.values, this.size());
    }

    @Override
    public T[] toArray(T[] a) {
        if (a.length < this.size()) {
            return (Comparable[])Arrays.copyOf(this.values, this.size(), a.getClass());
        }
        System.arraycopy(this.values, 0, a, 0, this.size());
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        return a;
    }

    @Override
    protected boolean doAppend(T t) {
        if (this.size == this.values.length - 1) {
            this.values = (Comparable[])Arrays.copyOf(this.values, (int)((double)this.values.length * 1.6));
        }
        this.values[this.size++] = t;
        return true;
    }

    @Override
    protected boolean doAppendNA() {
        return this.doAppend(null);
    }

    @Override
    public boolean isNA(int index) {
        return this.values.length <= index || this.values[index] == null;
    }

    @Override
    protected void doSetNA(int index) {
        this.values[index] = null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return new HashSet<T>(Arrays.asList(this.values)).containsAll(c);
    }

    @Override
    protected boolean doAppendAll(Collection<? extends T> c) {
        for (Comparable o : c) {
            this.doAppend(o);
        }
        return true;
    }

    @Override
    public void clear() {
        this.values = (Comparable[])Array.newInstance(this.getType(), 128);
        this.size = 0;
    }
}

