/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.column;

import de.unknownreality.dataframe.column.BasicColumn;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.common.parser.Parser;
import de.unknownreality.dataframe.common.parser.ParserUtil;

public class BooleanColumn
extends BasicColumn<Boolean, BooleanColumn> {
    private final Parser<Boolean> parser = ParserUtil.findParserOrNull(Boolean.class);

    public BooleanColumn and(BooleanColumn other) {
        for (int i = 0; i < Math.min(this.size(), other.size()); ++i) {
            ((Boolean[])this.values)[i] = ((Boolean[])this.values)[i] != false && ((Boolean[])other.values)[i] != false;
        }
        return this;
    }

    public BooleanColumn andNot(BooleanColumn other) {
        for (int i = 0; i < Math.min(this.size(), other.size()); ++i) {
            ((Boolean[])this.values)[i] = ((Boolean[])this.values)[i] != false && ((Boolean[])other.values)[i] == false;
        }
        return this;
    }

    public BooleanColumn or(BooleanColumn other) {
        for (int i = 0; i < Math.min(this.size(), other.size()); ++i) {
            ((Boolean[])this.values)[i] = ((Boolean[])this.values)[i] != false || ((Boolean[])other.values)[i] != false;
        }
        return this;
    }

    public BooleanColumn xor(BooleanColumn other) {
        for (int i = 0; i < Math.min(this.size(), other.size()); ++i) {
            ((Boolean[])this.values)[i] = ((Boolean[])this.values)[i] != ((Boolean[])other.values)[i];
        }
        return this;
    }

    public BooleanColumn flip() {
        for (int i = 0; i < this.size(); ++i) {
            ((Boolean[])this.values)[i] = ((Boolean[])this.values)[i] == false;
        }
        return this;
    }

    public BooleanColumn() {
    }

    public BooleanColumn(String name) {
        super(name);
    }

    public BooleanColumn(String name, Boolean[] values) {
        super(name, (Comparable[])values);
    }

    @Override
    protected BooleanColumn getThis() {
        return null;
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public Parser<Boolean> getParser() {
        return this.parser;
    }

    @Override
    public BooleanColumn copy() {
        Comparable[] copyValues = new Boolean[this.size()];
        this.toArray(copyValues);
        return new BooleanColumn(this.getName(), (Boolean[])copyValues);
    }

    @Override
    public <H> Boolean getValueFromRow(Row<?, H> row, H headerName) {
        return row.getBoolean(headerName);
    }

    @Override
    public Boolean getValueFromRow(Row<?, ?> row, int headerIndex) {
        return row.getBoolean(headerIndex);
    }
}

