/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class MultiIterator<T>
implements Iterator<T[]>,
Iterable<T[]> {
    private final Iterator[] iterators;
    private T[] next;
    private final Class<T> cl;

    public static <T> MultiIterator<T> create(Iterable<T>[] its, Class<T> cl) {
        return new MultiIterator<T>(its, cl);
    }

    public static <T> MultiIterator<T> create(Collection<? super Iterable<T>> its, Class<T> cl) {
        Iterable[] itsArray = new Iterable[its.size()];
        its.toArray(itsArray);
        return new MultiIterator<T>(itsArray, cl);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported by MultiIterators");
    }

    public MultiIterator(Iterable<T>[] iterables, Class<T> cl) {
        this.iterators = new Iterator[iterables.length];
        this.cl = cl;
        for (int i = 0; i < iterables.length; ++i) {
            this.iterators[i] = iterables[i].iterator();
        }
        this.next = this.getNext();
    }

    private T[] getNext() {
        Object[] next = (Object[])Array.newInstance(this.cl, this.iterators.length);
        boolean found = false;
        for (int i = 0; i < this.iterators.length; ++i) {
            if (this.iterators[i].hasNext()) {
                next[i] = this.iterators[i].next();
                found = true;
                continue;
            }
            next[i] = null;
        }
        if (!found) {
            return null;
        }
        return next;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T[] next() {
        T[] rows = this.next;
        this.next = this.getNext();
        return rows;
    }

    @Override
    public Iterator<T[]> iterator() {
        return this;
    }
}

