/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common;

import java.util.ArrayList;
import java.util.List;

public class StringUtil {
    private StringUtil() {
    }

    public static String putInQuotes(String input, Character quoteChar) {
        return quoteChar + input.replace(quoteChar.toString(), "\\" + quoteChar) + quoteChar;
    }

    public static String[] splitQuoted(String input, Character split) {
        ArrayList<String> parts = new ArrayList<String>();
        StringUtil.splitQuoted(input, split, parts);
        String[] result = new String[parts.size()];
        return parts.toArray(result);
    }

    public static void splitQuoted(String input, Character split, List<String> parts) {
        String p;
        boolean inQuotation = false;
        boolean inDoubleQuotation = false;
        boolean escapeNext = false;
        int currentStart = 0;
        char[] chars = input.trim().toCharArray();
        boolean startOrSplit = true;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            boolean escape = escapeNext;
            escapeNext = false;
            if (!escape && c == '\\') {
                escapeNext = true;
                continue;
            }
            if (c == '\'') {
                if (inQuotation && !escape) {
                    inQuotation = false;
                    continue;
                }
                if (!inDoubleQuotation && startOrSplit) {
                    inQuotation = true;
                }
                startOrSplit = false;
                continue;
            }
            if (c == '\"') {
                if (inDoubleQuotation && !escape) {
                    inDoubleQuotation = false;
                    continue;
                }
                if (!inDoubleQuotation && startOrSplit) {
                    inDoubleQuotation = true;
                }
                startOrSplit = false;
                continue;
            }
            if (c == split.charValue() && !inDoubleQuotation && !inQuotation) {
                int length = i - currentStart;
                p = length == 0 ? "" : input.substring(currentStart, currentStart + length);
                parts.add(p);
                currentStart = i + 1;
                startOrSplit = true;
                continue;
            }
            startOrSplit = false;
        }
        if (currentStart < chars.length) {
            p = input.substring(currentStart);
            parts.add(p);
        }
    }
}

