/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common.header;

import de.unknownreality.dataframe.common.Header;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BasicHeader
implements Header<String> {
    private final Map<String, Integer> headerMap = new HashMap<String, Integer>();
    private final List<String> headers = new ArrayList<String>();

    @Override
    public int size() {
        return this.headers.size();
    }

    public void add(String name) {
        this.headerMap.put(name, this.headers.size());
        this.headers.add(name);
    }

    @Override
    public String get(int index) {
        if (index >= this.headers.size()) {
            throw new IllegalArgumentException(String.format("header index out of bounds %d > %d", index, this.headers.size() - 1));
        }
        return this.headers.get(index);
    }

    @Override
    public boolean contains(String name) {
        return this.headerMap.containsKey(name);
    }

    @Override
    public int getIndex(String name) {
        Integer index = this.headerMap.get(name);
        if (index == null) {
            throw new IllegalArgumentException(String.format("column header name not found '%s'", name));
        }
        return index;
    }

    public void clear() {
        this.headerMap.clear();
        this.headers.clear();
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            final Iterator<String> it;
            {
                this.it = BasicHeader.this.headers.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported");
            }

            @Override
            public String next() {
                return this.it.next();
            }
        };
    }
}

