/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common.mapping;

import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.common.Header;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.common.mapping.FieldColumn;
import de.unknownreality.dataframe.common.mapping.MappedColumn;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMapper<T>
implements Iterable<T> {
    private static final Logger log = LoggerFactory.getLogger(DataMapper.class);
    private final DataContainer<? extends Header, ? extends Row> reader;
    private FieldColumn[] columns;
    private Map<Integer, FieldColumn> columnMap = new HashMap<Integer, FieldColumn>();
    private final Class<T> cl;

    private DataMapper(DataContainer<? extends Header, ? extends Row> reader, Class<T> cl) {
        this.reader = reader;
        this.cl = cl;
    }

    public static <T> List<T> map(DataContainer<? extends Header, ? extends Row> reader, Class<T> cl) {
        DataMapper<T> mapper = new DataMapper<T>(reader, cl);
        return mapper.map();
    }

    public static <T> Iterator<T> mapEach(DataContainer<? extends Header, ? extends Row> reader, Class<T> cl) {
        DataMapper<T> mapper = new DataMapper<T>(reader, cl);
        return mapper.iterator();
    }

    public List<T> map() {
        ArrayList<T> result = new ArrayList<T>();
        this.initFields(this.reader.getHeader());
        for (Row row : this.reader) {
            result.add(this.processRow(row));
        }
        return result;
    }

    private void initFields(Header header) {
        ArrayList<FieldColumn> fieldColumnList = new ArrayList<FieldColumn>();
        for (Field field : this.cl.getDeclaredFields()) {
            String name = field.getName();
            MappedColumn annotation = field.getAnnotation(MappedColumn.class);
            if (annotation == null) continue;
            String headerName = annotation.header();
            if (!this.isValid(headerName, header) && annotation.index() != -1 && annotation.index() < header.size()) {
                headerName = header.get(annotation.index()).toString();
            }
            if (!this.isValid(headerName, header)) {
                if (this.isValid(name, header)) {
                    headerName = name;
                } else {
                    log.error("{} not found in file", (Object)annotation.toString());
                    continue;
                }
            }
            fieldColumnList.add(new FieldColumn(field, headerName));
        }
        this.columns = new FieldColumn[fieldColumnList.size()];
        fieldColumnList.toArray(this.columns);
    }

    private boolean isValid(Object headerName, Header header) {
        return !"".equals(headerName) && header.contains(headerName);
    }

    private <R extends Row> T processRow(R row) {
        T obj = null;
        try {
            obj = this.cl.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        for (FieldColumn fieldColumn : this.columns) {
            fieldColumn.set(row, obj);
        }
        return obj;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final Iterator<? extends Row> rowIterator;
            {
                this.rowIterator = DataMapper.this.reader.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.rowIterator.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported by this iterator");
            }

            @Override
            public T next() {
                return DataMapper.this.processRow(this.rowIterator.next());
            }
        };
    }
}

