/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common.mapping;

import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.common.parser.ParserUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public class FieldColumn {
    private final Field field;
    private final String headerName;

    public FieldColumn(Field field, String headerName) {
        this.field = field;
        this.headerName = headerName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public Field getField() {
        return this.field;
    }

    public void set(Row row, Object object) {
        this.set(row.get(this.headerName), object);
    }

    public void set(Object value, Object object) {
        Object convertedVal = this.field.getType().isInstance(value) ? value : ParserUtil.parseOrNull(this.field.getType(), value.toString());
        try {
            if (Modifier.isPublic(this.field.getModifiers())) {
                this.field.set(object, convertedVal);
            } else {
                PropertyDescriptor objPropertyDescriptor = new PropertyDescriptor(this.field.getName(), object.getClass());
                objPropertyDescriptor.getWriteMethod().invoke(object, convertedVal);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

