/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common.row;

import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.common.Header;
import de.unknownreality.dataframe.common.Row;

public class BasicRow<T, H extends Header<T>, V>
implements Row<V, T> {
    private final V[] values;
    private final H header;
    private final int index;

    public BasicRow(H header, V[] values, int index) {
        this.header = header;
        this.values = values;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public V get(T headerName) {
        int headerIndex = this.header.getIndex(headerName);
        return this.values[headerIndex];
    }

    protected H getHeader() {
        return this.header;
    }

    @Override
    public V get(int index) {
        return this.values[index];
    }

    @Override
    public Double getDouble(int index) {
        V value = this.get(index);
        try {
            return ((Number)Number.class.cast(this.get(index))).doubleValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no double value in col " + index + " (" + value + ")");
        }
    }

    protected V[] getValues() {
        return this.values;
    }

    @Override
    public String getString(int index) {
        V value = this.get(index);
        if (value != null) {
            return value.toString();
        }
        throw new DataFrameRuntimeException("no String value in col " + index + " (null)");
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Boolean getBoolean(int index) {
        V value = this.get(index);
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        throw new DataFrameRuntimeException("no boolean value in col " + index + " (" + value + ")");
    }

    @Override
    public Double getDouble(T name) {
        V value = this.get(name);
        try {
            return ((Number)Number.class.cast(this.get(name))).doubleValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no double value in col " + name + " (" + value + ")");
        }
    }

    public Number getNumber(int index) {
        V value = this.get(index);
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new DataFrameRuntimeException("no number value in col " + index + " (" + value + ")");
    }

    public Number getNumber(T name) {
        return this.getNumber(this.header.getIndex(name));
    }

    @Override
    public String getString(T name) {
        return this.getString(this.header.getIndex(name));
    }

    @Override
    public Boolean getBoolean(T name) {
        return this.getBoolean(this.header.getIndex(name));
    }

    public Double toDouble(int index) {
        V v = this.get(index);
        try {
            return ((Number)Number.class.cast(v)).doubleValue();
        }
        catch (Exception exception) {
            try {
                return Double.parseDouble(String.valueOf(v));
            }
            catch (Exception e) {
                return Double.NaN;
            }
        }
    }

    public Double toDouble(T name) {
        return this.toDouble(this.header.getIndex(name));
    }

    @Override
    public Integer getInteger(int index) {
        V value = this.get(index);
        try {
            return ((Number)Number.class.cast(this.get(index))).intValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no int value in col " + index + " (" + value + ")");
        }
    }

    @Override
    public Integer getInteger(T headerName) {
        V value = this.get(headerName);
        try {
            return ((Number)Number.class.cast(value)).intValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no int value in col " + headerName + " (" + value + ")");
        }
    }

    @Override
    public Float getFloat(int index) {
        V value = this.get(index);
        try {
            return Float.valueOf(((Number)Number.class.cast(value)).floatValue());
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no float value in col " + index + " (" + value + ")");
        }
    }

    @Override
    public Float getFloat(T headerName) {
        V value = this.get(headerName);
        try {
            return Float.valueOf(((Number)Number.class.cast(value)).floatValue());
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no float value in col " + headerName + " (" + value + ")");
        }
    }

    @Override
    public Long getLong(int index) {
        V value = this.get(index);
        try {
            return ((Number)Number.class.cast(value)).longValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no long value in col " + index + " (" + value + ")");
        }
    }

    @Override
    public Long getLong(T headerName) {
        V value = this.get(headerName);
        try {
            return ((Number)Number.class.cast(value)).longValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no long value in col " + headerName + " (" + value + ")");
        }
    }

    @Override
    public Short getShort(int index) {
        V value = this.get(index);
        try {
            return ((Number)Number.class.cast(value)).shortValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no short value in col " + index + " (" + value + ")");
        }
    }

    @Override
    public Short getShort(T headerName) {
        V value = this.get(headerName);
        try {
            return ((Number)Number.class.cast(value)).shortValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no short value in col " + this.index + " (" + value + ")");
        }
    }

    @Override
    public Byte getByte(int index) {
        V value = this.get(index);
        try {
            return ((Number)Number.class.cast(value)).byteValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no byte value in col " + index + " (" + value + ")");
        }
    }

    @Override
    public Byte getByte(T headerName) {
        V value = this.get(headerName);
        try {
            return ((Number)Number.class.cast(value)).byteValue();
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no byte value in col " + this.index + " (" + value + ")");
        }
    }

    public boolean isNA(T headerName) {
        return this.get(headerName) == Values.NA || this.get(headerName) == null;
    }

    public boolean isNA(int index) {
        return this.get(index) == Values.NA || this.get(index) == null;
    }

    @Override
    public <C> C get(T headerName, Class<C> cl) {
        V value = this.get(headerName);
        try {
            return cl.cast(value);
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no " + cl.getName() + " value in col " + headerName + " (" + value + ")");
        }
    }

    @Override
    public <C> C getOrNull(T headerName, Class<C> cl) {
        V value = this.get(headerName);
        try {
            return cl.cast(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <C> C get(int index, Class<C> cl) {
        V value = this.get(index);
        try {
            return cl.cast(value);
        }
        catch (Exception e) {
            throw new DataFrameRuntimeException("no " + cl.getName() + " value in col " + index + " (" + value + ")");
        }
    }

    @Override
    public <C> C getOrNull(int index, Class<C> cl) {
        V value = this.get(index);
        try {
            return cl.cast(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        if (o == this) {
            return true;
        }
        BasicRow r = (BasicRow)o;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null && r.values[i] == null) continue;
            if (this.values[i] == null && r.values[i] != null) {
                return false;
            }
            if (this.values[i] != null && r.values[i] == null) {
                return false;
            }
            if (this.values[i].equals(r.values[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.index).append("] ");
        for (int i = 0; i < this.values.length; ++i) {
            sb.append(this.values[i]);
            if (i >= this.values.length - 1) continue;
            sb.append("\t");
        }
        return sb.toString();
    }
}

