/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common.row;

import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.common.Header;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.common.parser.Parser;
import de.unknownreality.dataframe.common.parser.ParserNotFoundException;
import de.unknownreality.dataframe.common.parser.ParserUtil;
import java.text.ParseException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringRow<T, H extends Header<T>>
implements Row<String, T>,
Iterable<String> {
    private static final Logger log = LoggerFactory.getLogger(StringRow.class);
    private final String[] values;
    private final H header;
    private final int rowNumber;
    private static final Parser<Boolean> BOOLEAN_PARSER = ParserUtil.findParserOrNull(Boolean.class);
    private static final Parser<Double> DOUBLE_PARSER = ParserUtil.findParserOrNull(Double.class);
    private static final Parser<Float> FLOAT_PARSER = ParserUtil.findParserOrNull(Float.class);
    private static final Parser<Long> LONG_PARSER = ParserUtil.findParserOrNull(Long.class);
    private static final Parser<Integer> INTEGER_PARSER = ParserUtil.findParserOrNull(Integer.class);
    private static final Parser<Short> SHORT_PARSER = ParserUtil.findParserOrNull(Short.class);
    private static final Parser<Byte> BYTE_PARSER = ParserUtil.findParserOrNull(Byte.class);

    public StringRow(H header, String[] values, int rowNumber) {
        this.values = values;
        this.header = header;
        this.rowNumber = rowNumber;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public String[] getValues() {
        return this.values;
    }

    @Override
    public String get(int index) {
        if (index >= this.values.length) {
            throw new IllegalArgumentException(String.format("header index out of bounds %d > %d", index, this.values.length - 1));
        }
        return this.values[index];
    }

    @Override
    public String get(T headerName) {
        int index = this.header.getIndex(headerName);
        return this.values[index];
    }

    @Override
    public String getString(int index) {
        return this.get(index);
    }

    @Override
    public String getString(T headerName) {
        return this.get((Object)headerName);
    }

    @Override
    public Boolean getBoolean(int index) {
        return this.parse(index, Boolean.class, BOOLEAN_PARSER);
    }

    @Override
    public Boolean getBoolean(T header) {
        return this.parse(header, Boolean.class, BOOLEAN_PARSER);
    }

    @Override
    public Double getDouble(int index) {
        return this.parse(index, Double.class, DOUBLE_PARSER);
    }

    @Override
    public Double getDouble(T header) {
        return this.parse(header, Double.class, DOUBLE_PARSER);
    }

    @Override
    public Long getLong(int index) {
        return this.parse(index, Long.class, LONG_PARSER);
    }

    @Override
    public Long getLong(T header) {
        return this.parse(header, Long.class, LONG_PARSER);
    }

    @Override
    public Short getShort(int index) {
        return this.parse(index, Short.class, SHORT_PARSER);
    }

    @Override
    public Short getShort(T headerName) {
        return this.parse(headerName, Short.class, SHORT_PARSER);
    }

    @Override
    public Byte getByte(int index) {
        return this.parse(index, Byte.class, BYTE_PARSER);
    }

    @Override
    public Byte getByte(T headerName) {
        return this.parse(headerName, Byte.class, BYTE_PARSER);
    }

    @Override
    public Integer getInteger(int index) {
        return this.parse(index, Integer.class, INTEGER_PARSER);
    }

    @Override
    public Integer getInteger(T header) {
        return this.parse(header, Integer.class, INTEGER_PARSER);
    }

    @Override
    public Float getFloat(int index) {
        return this.parse(index, Float.class, FLOAT_PARSER);
    }

    @Override
    public Float getFloat(T header) {
        return this.parse(header, Float.class, FLOAT_PARSER);
    }

    protected <C> C parse(T name, Class<C> cl, Parser<C> parser) {
        Object val = this.get((Object)name);
        try {
            return parser.parse((String)val);
        }
        catch (ParseException e) {
            log.error("error parsing value {} to {}", new Object[]{val, cl, e});
            throw new DataFrameRuntimeException(String.format("error parsing value %s to %s", val, cl), e);
        }
    }

    protected <C> C parse(int index, Class<C> cl, Parser<C> parser) {
        String val = this.get(index);
        try {
            return parser.parse(val);
        }
        catch (ParseException e) {
            log.error("error parsing value {} to {}", new Object[]{val, cl, e});
            throw new DataFrameRuntimeException(String.format("error parsing value %s to %s", val, cl), e);
        }
    }

    @Override
    public <C> C get(T headerName, Class<C> cl) {
        return this.getValueAs((String)this.get((Object)headerName), cl);
    }

    @Override
    public <C> C getOrNull(T headerName, Class<C> cl) {
        return this.getValueAsOrNull((String)this.get((Object)headerName), cl);
    }

    @Override
    public <C> C get(int index, Class<C> cl) {
        return this.getValueAs(this.get(index), cl);
    }

    @Override
    public <C> C getOrNull(int index, Class<C> cl) {
        return this.getValueAsOrNull(this.get(index), cl);
    }

    protected <C> C getValueAs(String value, Class<C> cl) {
        try {
            return ParserUtil.parse(cl, value);
        }
        catch (ParserNotFoundException | ParseException e) {
            log.error("error parsing value {} to {}", new Object[]{value, cl, e});
            throw new DataFrameRuntimeException(String.format("error parsing value %s to %s", value, cl), e);
        }
    }

    protected <C> C getValueAsOrNull(String value, Class<C> cl) {
        try {
            return ParserUtil.parse(cl, value);
        }
        catch (ParserNotFoundException | ParseException e) {
            log.warn("error parsing value {} to {}", new Object[]{value, cl, e});
            return null;
        }
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < StringRow.this.values.length - 1;
            }

            @Override
            public String next() {
                if (this.index >= StringRow.this.values.length) {
                    throw new NoSuchElementException(String.format("element not found: index out of bounds %s >= %s]", this.index, StringRow.this.values.length));
                }
                return StringRow.this.values[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported by CSVRows");
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String item : this.values) {
            if (first) {
                first = false;
            } else {
                sb.append('\t');
            }
            sb.append(item);
        }
        return sb.toString();
    }
}

