/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.common.row;

import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.common.Header;
import de.unknownreality.dataframe.common.row.BasicRow;

public abstract class UpdateableRow<T, H extends Header<T>, V>
extends BasicRow<T, H, V> {
    public UpdateableRow(H header, V[] values, int index) {
        super(header, values, index);
    }

    public void set(T headerName, V value) {
        if (!this.getHeader().contains(headerName)) {
            throw new DataFrameRuntimeException(String.format("header name not found '%s'", headerName));
        }
        if (!this.isCompatible(value, headerName)) {
            throw new DataFrameRuntimeException(String.format("the value (%s) is not compatible with this column (%s)", value.getClass(), headerName));
        }
        this.getValues()[this.getHeader().getIndex(headerName)] = value;
    }

    public abstract boolean isCompatible(V var1, T var2);

    public abstract boolean isCompatible(V var1, int var2);

    public void set(int index, V value) {
        if (this.getHeader().size() <= index || index < 0) {
            throw new DataFrameRuntimeException(String.format("invalid column index '%d'", index));
        }
        if (!this.isCompatible(value, index)) {
            throw new DataFrameRuntimeException(String.format("the value (%s) is not compatible with this column (%s)", value.getClass(), index));
        }
        this.getValues()[index] = value;
    }
}

