/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.common.GZipUtil;
import de.unknownreality.dataframe.csv.CSVIterator;
import de.unknownreality.dataframe.csv.CSVReader;
import de.unknownreality.dataframe.csv.CSVRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVFileReader
extends CSVReader {
    private static final Logger log = LoggerFactory.getLogger(CSVFileReader.class);
    private final File file;
    private final boolean gzipped;
    private int skip = 0;

    public CSVFileReader(File file, Character separator, boolean containsHeader, String headerPrefix, String[] ignorePrefixes) {
        super(separator, containsHeader, headerPrefix, ignorePrefixes);
        this.file = file;
        this.gzipped = GZipUtil.isGzipped(file);
        this.initHeader();
        if (containsHeader) {
            ++this.skip;
        }
    }

    @Override
    public CSVIterator iterator() {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.file);
            if (this.gzipped) {
                try {
                    inputStream = new GZIPInputStream(inputStream);
                }
                catch (IOException e) {
                    log.error("error creating gzip input stream", (Throwable)e);
                }
            }
            return new CSVIterator(inputStream, this.getHeader(), this.getSeparator(), this.getIgnorePrefixes(), this.skip);
        }
        catch (FileNotFoundException e) {
            throw new CSVRuntimeException(String.format("file not found: %s", this.file.getAbsolutePath()));
        }
    }
}

