/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.common.StringUtil;
import de.unknownreality.dataframe.common.reader.BufferedStreamIterator;
import de.unknownreality.dataframe.csv.CSVException;
import de.unknownreality.dataframe.csv.CSVHeader;
import de.unknownreality.dataframe.csv.CSVRow;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVIterator
extends BufferedStreamIterator<CSVRow> {
    private static final Logger log = LoggerFactory.getLogger(CSVIterator.class);
    private int lineNumber = 0;
    private final Character separator;
    private int cols = -1;
    private final CSVHeader header;
    private final String[] ignorePrefixes;

    public CSVIterator(InputStream stream, CSVHeader header, Character separator, String[] ignorePrefixes, int skip) {
        super(stream);
        this.separator = separator;
        this.header = header;
        this.ignorePrefixes = ignorePrefixes;
        this.skip(skip);
        this.loadNext();
    }

    @Override
    protected CSVRow getNext() {
        try {
            ++this.lineNumber;
            String line = this.getLine();
            while (line != null && "".equals(line.trim())) {
                line = this.getLine();
            }
            if (line == null) {
                return null;
            }
            for (String prefix : this.ignorePrefixes) {
                if (prefix == null || "".equals(prefix) || !line.startsWith(prefix)) continue;
                return this.getNext();
            }
            String[] values = StringUtil.splitQuoted(line, this.separator);
            if (this.cols == -1) {
                this.cols = values.length;
            } else if (values.length != this.cols) {
                throw new CSVException(String.format("unequal number of column %d != %d in line %d", values.length, this.cols, this.lineNumber));
            }
            return new CSVRow(this.header, values, this.lineNumber);
        }
        catch (IOException e) {
            log.error("error reading file: {}:{}", (Object)this.lineNumber, (Object)e);
            this.close();
        }
        catch (CSVException e) {
            log.error("error parsing file: {}:{}", (Object)this.lineNumber, (Object)e);
            this.close();
        }
        return null;
    }
}

