/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.common.MultiIterator;
import de.unknownreality.dataframe.csv.CSVReader;
import de.unknownreality.dataframe.csv.CSVReaderBuilder;
import de.unknownreality.dataframe.csv.CSVRow;
import java.io.File;

public class CSVMultiReaderBuilder {
    private final File[] files;
    private Character separator = Character.valueOf('\t');
    private String headerPrefix = "#";
    private boolean containsHeader = true;

    private CSVMultiReaderBuilder(File[] files) {
        this.files = files;
    }

    public static CSVMultiReaderBuilder create(File[] files) {
        return new CSVMultiReaderBuilder(files);
    }

    public CSVMultiReaderBuilder withSeparator(Character separator) {
        this.separator = separator;
        return this;
    }

    public CSVMultiReaderBuilder containsHeader(boolean containsHeader) {
        this.containsHeader = containsHeader;
        return this;
    }

    public CSVMultiReaderBuilder withHeaderPrefix(String headerPrefix) {
        this.headerPrefix = headerPrefix;
        return this;
    }

    public MultiIterator<CSVRow> build() {
        CSVReader[] readers = new CSVReader[this.files.length];
        for (int i = 0; i < readers.length; ++i) {
            readers[i] = CSVReaderBuilder.create().containsHeader(this.containsHeader).withHeaderPrefix(this.headerPrefix).withSeparator(this.separator).load(this.files[i]);
        }
        return MultiIterator.create(readers, CSVRow.class);
    }
}

