/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.DataFrameBuilder;
import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.common.mapping.DataMapper;
import de.unknownreality.dataframe.csv.CSVException;
import de.unknownreality.dataframe.csv.CSVHeader;
import de.unknownreality.dataframe.csv.CSVIterator;
import de.unknownreality.dataframe.csv.CSVRow;
import de.unknownreality.dataframe.csv.CSVRuntimeException;
import java.util.List;

public abstract class CSVReader
implements DataContainer<CSVHeader, CSVRow> {
    private String headerPrefix = "#";
    private final Character separator;
    private final CSVHeader header = new CSVHeader();
    private boolean containsHeader;
    private final String[] ignorePrefixes;

    protected CSVReader(Character separator, boolean containsHeader, String headerPrefix, String[] ignorePrefixes) {
        this.separator = separator;
        this.containsHeader = containsHeader;
        this.headerPrefix = headerPrefix;
        this.ignorePrefixes = ignorePrefixes;
    }

    public boolean containsHeader() {
        return this.containsHeader;
    }

    public String getHeaderPrefix() {
        return this.headerPrefix;
    }

    public Character getSeparator() {
        return this.separator;
    }

    @Override
    public CSVHeader getHeader() {
        return this.header;
    }

    public String[] getIgnorePrefixes() {
        return this.ignorePrefixes;
    }

    public void initHeader() {
        try {
            CSVIterator iterator = this.iterator();
            CSVRow row = (CSVRow)iterator.next();
            if (row == null) {
                this.containsHeader = false;
                return;
            }
            if (this.containsHeader) {
                if (!row.get(0).startsWith(this.headerPrefix)) {
                    throw new CSVException("invalid header prefix in first line");
                }
                String name = row.get(0);
                name = this.headerPrefix == null ? name : name.substring(this.headerPrefix.length());
                this.header.add(name);
                for (int i = 1; i < row.size(); ++i) {
                    name = row.get(i);
                    this.header.add(name);
                }
            } else {
                for (int i = 0; i < row.size(); ++i) {
                    this.header.add();
                }
                this.containsHeader = false;
            }
            iterator.close();
        }
        catch (CSVException e) {
            throw new CSVRuntimeException("error creating csv header", e);
        }
    }

    public abstract CSVIterator iterator();

    public DataFrameBuilder toDataFrame() {
        return DataFrameBuilder.create(this);
    }

    @Override
    public <T> List<T> map(Class<T> cl) {
        return DataMapper.map(this, cl);
    }
}

