/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.common.ReaderBuilder;
import de.unknownreality.dataframe.common.parser.ParserUtil;
import de.unknownreality.dataframe.csv.CSVFileReader;
import de.unknownreality.dataframe.csv.CSVHeader;
import de.unknownreality.dataframe.csv.CSVReader;
import de.unknownreality.dataframe.csv.CSVResourceReader;
import de.unknownreality.dataframe.csv.CSVRow;
import de.unknownreality.dataframe.csv.CSVStringReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CSVReaderBuilder
implements ReaderBuilder<CSVHeader, CSVRow> {
    private Character separator = Character.valueOf('\t');
    private String headerPrefix = "#";
    private boolean containsHeader = true;
    private final List<String> ignorePrefixes = new ArrayList<String>();

    public static CSVReaderBuilder create() {
        return new CSVReaderBuilder();
    }

    public CSVReaderBuilder withSeparator(Character separator) {
        this.separator = separator;
        return this;
    }

    public CSVReaderBuilder containsHeader(boolean containsHeader) {
        this.containsHeader = containsHeader;
        return this;
    }

    public CSVReaderBuilder addIgnorePrefix(String prefix) {
        this.ignorePrefixes.add(prefix);
        return this;
    }

    public CSVReaderBuilder withHeaderPrefix(String headerPrefix) {
        this.headerPrefix = headerPrefix;
        return this;
    }

    public Character getSeparator() {
        return this.separator;
    }

    public String getHeaderPrefix() {
        return this.headerPrefix;
    }

    public boolean isContainsHeader() {
        return this.containsHeader;
    }

    public CSVReader load(File file) {
        String[] ignorePrefixesArray = new String[this.ignorePrefixes.size()];
        this.ignorePrefixes.toArray(ignorePrefixesArray);
        return new CSVFileReader(file, this.getSeparator(), this.isContainsHeader(), this.getHeaderPrefix(), ignorePrefixesArray);
    }

    public CSVReader load(String content) {
        String[] ignorePrefixesArray = new String[this.ignorePrefixes.size()];
        this.ignorePrefixes.toArray(ignorePrefixesArray);
        return new CSVStringReader(content, this.getSeparator(), this.isContainsHeader(), this.getHeaderPrefix(), ignorePrefixesArray);
    }

    public CSVReader loadResource(String resourcePath, ClassLoader classLoader) {
        String[] ignorePrefixesArray = new String[this.ignorePrefixes.size()];
        this.ignorePrefixes.toArray(ignorePrefixesArray);
        return new CSVResourceReader(resourcePath, classLoader, this.getSeparator(), this.isContainsHeader(), this.getHeaderPrefix(), ignorePrefixesArray);
    }

    public CSVReader loadResource(String resourcePath) {
        String[] ignorePrefixesArray = new String[this.ignorePrefixes.size()];
        this.ignorePrefixes.toArray(ignorePrefixesArray);
        return new CSVResourceReader(resourcePath, this.getSeparator(), this.isContainsHeader(), this.getHeaderPrefix(), ignorePrefixesArray);
    }

    @Override
    public void loadAttributes(Map<String, String> attributes) throws Exception {
        this.separator = ParserUtil.parse(Character.class, attributes.get("separator"));
        this.headerPrefix = attributes.get("headerPrefix");
        this.containsHeader = ParserUtil.parse(Boolean.class, attributes.get("containsHeader"));
    }

    @Override
    public DataContainer<CSVHeader, CSVRow> fromFile(File f) {
        return this.load(f);
    }

    @Override
    public DataContainer<CSVHeader, CSVRow> fromString(String content) {
        return this.load(content);
    }

    @Override
    public DataContainer<CSVHeader, CSVRow> fromResource(String content, ClassLoader classLoader) {
        return this.loadResource(content, classLoader);
    }
}

