/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.csv.CSVIterator;
import de.unknownreality.dataframe.csv.CSVReader;
import java.io.InputStream;

public class CSVResourceReader
extends CSVReader {
    private final String resourcePath;
    private final ClassLoader classLoader;
    private int skip = 0;

    public CSVResourceReader(String resourcePath, ClassLoader classLoader, Character separator, boolean containsHeader, String headerPrefix, String[] ignorePrefixes) {
        super(separator, containsHeader, headerPrefix, ignorePrefixes);
        this.resourcePath = resourcePath;
        this.classLoader = classLoader;
        this.initHeader();
        if (containsHeader) {
            ++this.skip;
        }
    }

    public CSVResourceReader(String resourcePath, Character separator, boolean containsHeader, String headerPrefix, String[] ignorePrefixes) {
        this(resourcePath, CSVResourceReader.class.getClassLoader(), separator, containsHeader, headerPrefix, ignorePrefixes);
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public CSVIterator iterator() {
        InputStream inputStream = this.classLoader.getResourceAsStream(this.resourcePath);
        if (inputStream == null) {
            throw new DataFrameRuntimeException(String.format("resource not found '%s'", this.resourcePath));
        }
        return new CSVIterator(inputStream, this.getHeader(), this.getSeparator(), this.getIgnorePrefixes(), this.skip);
    }
}

