/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.csv.CSVIterator;
import de.unknownreality.dataframe.csv.CSVReader;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;

public class CSVStringReader
extends CSVReader {
    private final String content;
    private int skip = 0;

    public CSVStringReader(String content, Character separator, boolean containsHeader, String headerPrefix, String[] ignorePrefixes) {
        super(separator, containsHeader, headerPrefix, ignorePrefixes);
        this.content = content;
        this.initHeader();
        if (containsHeader) {
            ++this.skip;
        }
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public CSVIterator iterator() {
        return new CSVIterator(new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8)), this.getHeader(), this.getSeparator(), this.getIgnorePrefixes(), this.skip);
    }
}

