/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.common.DataContainer;
import de.unknownreality.dataframe.common.DataWriter;
import de.unknownreality.dataframe.common.Header;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.csv.CSVReaderBuilder;
import de.unknownreality.dataframe.meta.DataFrameMeta;
import de.unknownreality.dataframe.meta.DataFrameMetaWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVWriter
implements DataWriter {
    private static final Logger log = LoggerFactory.getLogger(CSVWriter.class);
    private char separator = (char)9;
    private String headerPrefix = "#";
    private boolean containsHeader = true;
    private boolean gzip = false;

    protected CSVWriter(char separator, boolean containsHeader, String headerPrefix, boolean gzip) {
        this.separator = separator;
        this.containsHeader = containsHeader;
        this.headerPrefix = headerPrefix;
        this.gzip = gzip;
    }

    public static void write(File file, DataContainer dataContainer, char separator) {
        CSVWriter.write(file, dataContainer, separator, true, "", true);
    }

    public static void write(File file, DataContainer dataContainer, char separator, boolean containsHeader, String headerPrefix) {
        CSVWriter.write(file, dataContainer, separator, containsHeader, headerPrefix, false);
    }

    public static void write(File file, DataContainer<?, ?> dataContainer, char separator, boolean containsHeader, String headerPrefix, boolean gzip) {
        new CSVWriter(separator, containsHeader, headerPrefix, gzip).write(file, dataContainer);
    }

    public static void print(DataContainer<?, ?> dataContainer, char separator, boolean containsHeader, String headerPrefix) {
        new CSVWriter(separator, containsHeader, headerPrefix, false).print(dataContainer);
    }

    @Override
    public void write(File file, DataContainer<? extends Header, ? extends Row> dataContainer) {
        try (BufferedWriter writer = this.initWriter(file);){
            if (this.containsHeader) {
                if (this.headerPrefix != null) {
                    writer.write(this.headerPrefix);
                }
                for (int i = 0; i < dataContainer.getHeader().size(); ++i) {
                    writer.write(dataContainer.getHeader().get(i).toString());
                    if (i >= dataContainer.getHeader().size() - 1) continue;
                    writer.write(this.separator);
                }
                writer.newLine();
            }
            for (Row row : dataContainer) {
                for (int i = 0; i < row.size(); ++i) {
                    writer.write(row.get(i).toString());
                    if (i >= row.size() - 1) continue;
                    writer.write(this.separator);
                }
                writer.newLine();
            }
        }
        catch (IOException e) {
            log.error("error writing {}", (Object)file, (Object)e);
        }
    }

    @Override
    public void write(File file, DataFrame dataFrame, boolean writeMetaFile) {
        this.write(file, dataFrame);
        if (writeMetaFile) {
            this.writeMetaFile(dataFrame, new File(file.getAbsolutePath() + ".dfm"));
        }
    }

    private void writeMetaFile(DataFrame dataFrame, File file) {
        DataFrameMeta metaFile = DataFrameMeta.create(dataFrame, CSVReaderBuilder.class, this.getAttributes());
        DataFrameMetaWriter.write(metaFile, file);
    }

    private BufferedWriter initWriter(File file) throws IOException {
        if (!file.getParentFile().isDirectory()) {
            file.getParentFile().mkdirs();
        }
        OutputStream outputStream = this.gzip ? new GZIPOutputStream(new FileOutputStream(file)) : new FileOutputStream(file);
        return new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
    }

    @Override
    public void print(DataContainer<? extends Header, ? extends Row> dataContainer) {
        this.print(System.out, dataContainer);
    }

    @Override
    public void print(PrintStream printWriter, DataContainer<? extends Header, ? extends Row> dataContainer) {
        if (this.containsHeader) {
            if (this.headerPrefix != null) {
                printWriter.print(this.headerPrefix);
            }
            for (int i = 0; i < dataContainer.getHeader().size(); ++i) {
                printWriter.print(dataContainer.getHeader().get(i).toString());
                if (i >= dataContainer.getHeader().size() - 1) continue;
                printWriter.print(this.separator);
            }
            printWriter.println();
        }
        for (Row row : dataContainer) {
            for (int i = 0; i < row.size(); ++i) {
                printWriter.print(row.get(i).toString());
                if (i >= row.size() - 1) continue;
                printWriter.print(this.separator);
            }
            printWriter.println();
        }
    }

    @Override
    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("separator", Character.toString(this.separator));
        attributes.put("headerPrefix", this.headerPrefix);
        attributes.put("containsHeader", Boolean.toString(this.containsHeader));
        attributes.put("gzip", Boolean.toString(this.gzip));
        return attributes;
    }
}

