/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.csv;

import de.unknownreality.dataframe.csv.CSVWriter;

public class CSVWriterBuilder {
    private char separator = (char)9;
    private String headerPrefix = "#";
    private boolean containsHeader = true;
    private boolean gzip = false;

    public static CSVWriterBuilder create() {
        return new CSVWriterBuilder();
    }

    public CSVWriterBuilder withSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public CSVWriterBuilder containsHeader(boolean containsHeader) {
        this.containsHeader = containsHeader;
        return this;
    }

    public CSVWriterBuilder withHeaderPrefix(String headerPrefix) {
        this.headerPrefix = headerPrefix;
        return this;
    }

    public CSVWriterBuilder useGzip(boolean gzip) {
        this.gzip = gzip;
        return this;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String getHeaderPrefix() {
        return this.headerPrefix;
    }

    public boolean isContainsHeader() {
        return this.containsHeader;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public CSVWriter build() {
        return new CSVWriter(this.getSeparator(), this.isContainsHeader(), this.getHeaderPrefix(), this.isGzip());
    }
}

