/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.filter;

import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.filter.FilterPredicate;

public class ComparePredicate
extends FilterPredicate {
    private final String headerName;
    private final Object value;
    private final Operation operation;

    public ComparePredicate(String headerName, Operation op, Object value) {
        this.headerName = headerName;
        this.operation = op;
        this.value = value;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean valid(Row row) {
        return this.compare(row.get(this.headerName), this.value);
    }

    protected boolean compare(Object valueA, Object valueB) {
        boolean numberCompare;
        if (this.operation == Operation.EQ && valueA.equals(valueB)) {
            return true;
        }
        boolean bl = numberCompare = valueA instanceof Number && valueB instanceof Number;
        if (!valueA.getClass().equals(valueB.getClass()) && !numberCompare) {
            return this.operation == Operation.NE;
        }
        int c = 0;
        if (numberCompare) {
            c = Double.compare(((Number)Number.class.cast(valueA)).doubleValue(), ((Number)Number.class.cast(valueB)).doubleValue());
        } else if (valueA instanceof Comparable && valueB instanceof Comparable) {
            c = ((Comparable)valueA).compareTo(valueB);
        }
        switch (this.operation) {
            case GT: {
                return c > 0;
            }
            case GE: {
                return c >= 0;
            }
            case LT: {
                return c < 0;
            }
            case LE: {
                return c <= 0;
            }
            case EQ: {
                return c == 0;
            }
            case NE: {
                return c != 0;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.headerName + " " + (Object)((Object)this.operation) + " " + this.value;
    }

    public static enum Operation {
        GT(">"),
        GE(">="),
        LT("<"),
        LE("<="),
        EQ("=="),
        NE("!=");

        private final String str;

        private Operation(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

