/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.filter;

import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.filter.FilterPredicate;
import java.util.regex.Pattern;

public class MatchPredicate
extends FilterPredicate {
    private final Pattern pattern;
    private final String headerName;

    public MatchPredicate(String headerName, String patternString) {
        this(headerName, Pattern.compile(patternString));
    }

    public MatchPredicate(String headerName, Pattern pattern) {
        this.headerName = headerName;
        this.pattern = pattern;
    }

    @Override
    public boolean valid(Row row) {
        Object v = row.get(this.headerName);
        return this.pattern.matcher(v.toString()).matches();
    }

    @Override
    public String toString() {
        return this.headerName + " =~ /" + this.pattern.toString() + "/";
    }
}

