/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.filter.compile;

import de.unknownreality.dataframe.common.parser.ParserUtil;
import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.filter.compile.BooleanFilterVisitor;
import de.unknownreality.dataframe.filter.compile.ColumnPredicateFilterVisitor;
import de.unknownreality.dataframe.filter.compile.FieldFilterOperation;
import de.unknownreality.dataframe.filter.compile.PredicateCompilerException;
import de.unknownreality.dataframe.filter.compile.RegexFilterVisitor;
import de.unknownreality.dataframe.generated.PredicateBaseVisitor;
import de.unknownreality.dataframe.generated.PredicateParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldFilterVisitor
extends PredicateBaseVisitor<FilterPredicate> {
    private static Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+([\\.,][0-9]+)?");

    @Override
    public FilterPredicate visitField_filter(PredicateParser.Field_filterContext ctx) {
        FilterPredicate result = null;
        if (ctx.regex_filter() != null) {
            RegexFilterVisitor regexFilterVisitor = new RegexFilterVisitor();
            result = regexFilterVisitor.visitRegex_filter(ctx.regex_filter());
        } else if (ctx.column_predicate() != null) {
            ColumnPredicateFilterVisitor columnPredicateFilterVisitor = new ColumnPredicateFilterVisitor();
            result = columnPredicateFilterVisitor.visitColumn_predicate(ctx.column_predicate());
        } else if (ctx.boolean_filter() != null) {
            BooleanFilterVisitor booleanFilterVisitor = new BooleanFilterVisitor();
            result = booleanFilterVisitor.visitBoolean_filter(ctx.boolean_filter());
        } else {
            result = FieldFilterVisitor.createFieldFilter(ctx);
        }
        if (ctx.NEGATE() != null) {
            result = result.neg();
        }
        return result;
    }

    private static FilterPredicate createFieldFilter(PredicateParser.Field_filterContext ctx) {
        String colName = FieldFilterVisitor.getColname(ctx.variable().getText());
        String operation = ctx.FIELD_OPERATION().getText();
        Comparable value = FieldFilterVisitor.getValue(ctx);
        return FieldFilterVisitor.createFieldFilter(colName, value, operation);
    }

    private static FilterPredicate createFieldFilter(String colName, Comparable value, String operation) {
        FieldFilterOperation fieldFilterOperation = FieldFilterOperation.find(operation);
        switch (fieldFilterOperation) {
            case EQ: {
                return FilterPredicate.eq(colName, value);
            }
            case NE: {
                return FilterPredicate.ne(colName, value);
            }
            case LE: {
                return FilterPredicate.le(colName, value);
            }
            case LT: {
                return FilterPredicate.lt(colName, value);
            }
            case GE: {
                return FilterPredicate.ge(colName, value);
            }
            case GT: {
                return FilterPredicate.gt(colName, value);
            }
        }
        throw new PredicateCompilerException(String.format("unsupported filter operation '%s'", operation));
    }

    public static String getColname(String text) {
        String colName;
        if (text.startsWith(".")) {
            text = text.substring(1);
        }
        if ((colName = text).startsWith("'")) {
            return colName.substring(1, colName.length() - 1);
        }
        return colName;
    }

    private static Comparable getValue(PredicateParser.Field_filterContext ctx) {
        if (ctx.value().NUMBER() != null) {
            String n = ctx.value().NUMBER().getText();
            try {
                if (n.contains(".")) {
                    return ParserUtil.parse(Double.class, n);
                }
                return ParserUtil.parse(Long.class, n);
            }
            catch (Exception e) {
                throw new PredicateCompilerException(String.format("error parsing value '%s'", ctx.value().BOOLEAN_VALUE().getText()));
            }
        }
        if (ctx.value().BOOLEAN_VALUE() != null) {
            try {
                return ParserUtil.parse(Boolean.class, ctx.value().BOOLEAN_VALUE().getText());
            }
            catch (Exception e) {
                throw new PredicateCompilerException(String.format("error parsing value '%s'", ctx.value().BOOLEAN_VALUE().getText()));
            }
        }
        String value = ctx.value().getText();
        if (value.startsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        Matcher m = NUMBER_PATTERN.matcher(value);
        if (m.matches()) {
            String n = m.group();
            n.replace(",", "");
            if (n.contains(".")) {
                return Double.valueOf(Double.parseDouble(n));
            }
            return Long.valueOf(Long.parseLong(n));
        }
        return value;
    }
}

