/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.filter.compile;

import java.util.HashMap;
import java.util.Map;

public enum PredicateOperation {
    AND("AND", "and", "&", "&&"),
    OR("OR", "or", "|", "||"),
    NOR("NOR", "nor"),
    XOR("XOR", "xor");

    private String[] aliases;
    private static final Map<String, PredicateOperation> ALIASES_MAP;

    private PredicateOperation(String ... aliases) {
        this.aliases = aliases;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public static PredicateOperation find(String alias) {
        return ALIASES_MAP.get(alias);
    }

    static {
        ALIASES_MAP = new HashMap<String, PredicateOperation>();
        for (PredicateOperation predicateOperation : PredicateOperation.values()) {
            for (String alias : predicateOperation.aliases) {
                ALIASES_MAP.put(alias, predicateOperation);
            }
        }
    }
}

