/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.group;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.group.GroupHeader;
import de.unknownreality.dataframe.group.GroupValues;

public class DataGroup
extends DataFrame {
    private GroupHeader groupHeader;
    private GroupValues groupValues;

    public DataGroup(String[] columns, Comparable[] values) {
        if (columns.length != values.length) {
            throw new IllegalArgumentException("column and values must have same length");
        }
        this.groupHeader = new GroupHeader(columns);
        Comparable[] groupValueArray = new Comparable[values.length];
        System.arraycopy(values, 0, groupValueArray, 0, values.length);
        this.groupValues = new GroupValues(groupValueArray, this.groupHeader);
    }

    public GroupHeader getGroupHeader() {
        return this.groupHeader;
    }

    public GroupValues getGroupValues() {
        return this.groupValues;
    }

    public String getGroupDescription() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String h : this.groupHeader) {
            sb.append(h).append("=").append(this.groupValues.get(h));
            if (i++ >= this.groupHeader.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

