/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.group;

import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.common.MultiKey;
import de.unknownreality.dataframe.filter.FilterPredicate;
import de.unknownreality.dataframe.group.DataGroup;
import de.unknownreality.dataframe.group.GroupValueComparator;
import de.unknownreality.dataframe.sort.SortColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class DataGrouping
implements Iterable<DataGroup> {
    private DataGroup[] groups;
    private final String[] groupColumns;
    private final Map<MultiKey, DataGroup> groupMap = new HashMap<MultiKey, DataGroup>();

    public DataGrouping(Collection<DataGroup> groups, String ... groupColumns) {
        this.groupColumns = groupColumns;
        this.groups = new DataGroup[groups.size()];
        groups.toArray(this.groups);
        for (DataGroup g : groups) {
            this.groupMap.put(this.getKey(g.getGroupValues().getValues()), g);
        }
    }

    public DataGrouping concat(DataGrouping other) {
        if (!Arrays.equals(this.getGroupColumns(), other.getGroupColumns())) {
            throw new DataFrameRuntimeException("other DataGrouping must have the same GroupColumns");
        }
        DataGroup[] newGroups = new DataGroup[this.groups.length + other.size()];
        System.arraycopy(this.groups, 0, newGroups, 0, this.groups.length);
        int i = this.groups.length;
        for (DataGroup g : other) {
            newGroups[i++] = g;
            this.groupMap.put(this.getKey(g.getGroupValues().getValues()), g);
        }
        this.groups = newGroups;
        return this;
    }

    private MultiKey getKey(Comparable ... values) {
        return new MultiKey(values);
    }

    public DataGroup findByGroupValues(Comparable ... values) {
        if (values.length != this.groupColumns.length) {
            throw new DataFrameRuntimeException("values must have same length as GroupColumns");
        }
        return this.groupMap.get(this.getKey(values));
    }

    public String[] getGroupColumns() {
        return this.groupColumns;
    }

    public int size() {
        return this.groups.length;
    }

    private List<DataGroup> findGroups(FilterPredicate predicate) {
        ArrayList<DataGroup> groupList = new ArrayList<DataGroup>();
        for (DataGroup g : this) {
            if (!predicate.valid(g.getGroupValues())) continue;
            groupList.add(g);
        }
        return groupList;
    }

    public DataGrouping filter(FilterPredicate predicate) {
        List<DataGroup> groupList = this.findGroups(predicate);
        this.groups = new DataGroup[groupList.size()];
        groupList.toArray(this.groups);
        return this;
    }

    public DataGrouping find(FilterPredicate predicate) {
        List<DataGroup> groupList = this.findGroups(predicate);
        return new DataGrouping(groupList, this.groupColumns);
    }

    public DataGrouping find(String colName, Comparable value) {
        return this.find(FilterPredicate.eq(colName, value));
    }

    public DataGroup findFirst(String colName, Comparable value) {
        return this.findFirst(FilterPredicate.eq(colName, value));
    }

    public DataGroup findFirst(FilterPredicate predicate) {
        for (DataGroup row : this) {
            if (!predicate.valid(row.getGroupValues())) continue;
            return row;
        }
        return null;
    }

    public DataGrouping sort(SortColumn ... columns) {
        Arrays.sort(this.groups, new GroupValueComparator(columns));
        return this;
    }

    public DataGrouping sort(String name) {
        return this.sort(name, SortColumn.Direction.Ascending);
    }

    public DataGrouping sort(String name, SortColumn.Direction dir) {
        Arrays.sort(this.groups, new GroupValueComparator(new SortColumn[]{new SortColumn(name, dir)}));
        return this;
    }

    public DataGrouping sort(Comparator<DataGroup> comp) {
        Arrays.sort(this.groups, comp);
        return this;
    }

    @Override
    public Iterator<DataGroup> iterator() {
        return new Iterator<DataGroup>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DataGrouping.this.groups.length;
            }

            @Override
            public DataGroup next() {
                if (this.index >= DataGrouping.this.groups.length) {
                    throw new NoSuchElementException(String.format("group not found: index out of bounds %s >= %s]", this.index, DataGrouping.this.groups.length));
                }
                return DataGrouping.this.groups[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported in data groupings");
            }
        };
    }
}

