/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.group;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.group.DataGroup;
import de.unknownreality.dataframe.group.DataGrouping;
import de.unknownreality.dataframe.sort.SortColumn;
import java.util.ArrayList;

public class GroupUtil {
    public static DataGrouping groupBy(DataFrame df, String ... columns) {
        SortColumn[] sortColumns = new SortColumn[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            sortColumns[i] = new SortColumn(columns[i]);
        }
        DataFrame sortedFrame = df.copy().sort(sortColumns);
        ArrayList<DataRow> currentList = new ArrayList<DataRow>();
        Object[] lastValues = null;
        ArrayList<DataGroup> groupList = new ArrayList<DataGroup>();
        for (DataRow row : sortedFrame) {
            if (lastValues == null || GroupUtil.equals(lastValues, row, columns)) {
                currentList.add(row);
                if (lastValues != null) continue;
                lastValues = new Comparable[columns.length];
                GroupUtil.set(lastValues, row, columns);
                continue;
            }
            if (!currentList.isEmpty()) {
                DataGroup group = new DataGroup(columns, (Comparable[])lastValues);
                group.set(df.getHeader().copy(), currentList);
                groupList.add(group);
            }
            currentList.clear();
            currentList.add(row);
            GroupUtil.set(lastValues, row, columns);
        }
        if (!currentList.isEmpty()) {
            DataGroup group = new DataGroup(columns, (Comparable[])lastValues);
            group.set(df.getHeader().copy(), currentList);
            groupList.add(group);
        }
        return new DataGrouping(groupList, columns);
    }

    private static boolean equals(Object[] values, DataRow row, String[] columns) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null && !row.isNA(i)) {
                return false;
            }
            if (values[i] != null && row.isNA(i)) {
                return false;
            }
            if (values[i] == null && row.isNA(i) || values[i].equals(row.get(columns[i]))) continue;
            return false;
        }
        return true;
    }

    private static void set(Object[] values, DataRow row, String[] columns) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = row.get(columns[i]);
        }
    }
}

