/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.group;

import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.group.DataGroup;
import de.unknownreality.dataframe.sort.SortColumn;
import java.util.Comparator;

public class GroupValueComparator
implements Comparator<DataGroup> {
    private final SortColumn[] sortColumns;

    public GroupValueComparator(SortColumn[] sortColumns) {
        this.sortColumns = sortColumns;
    }

    @Override
    public int compare(DataGroup r1, DataGroup r2) {
        int c = 0;
        for (SortColumn sortColumn : this.sortColumns) {
            boolean r2NA;
            Comparable r1Val = r1.getGroupValues().get(sortColumn.getName());
            Comparable r2Val = r2.getGroupValues().get(sortColumn.getName());
            boolean r1NA = r1Val == null || r1Val == Values.NA;
            boolean bl = r2NA = r2Val == null || r2Val == Values.NA;
            if (r1NA && r2NA) {
                c = 0;
                continue;
            }
            if (r1NA) {
                return 1;
            }
            if (r2NA) {
                return -1;
            }
            c = r1Val.compareTo(r2Val);
            int n = c = sortColumn.getDirection() == SortColumn.Direction.Ascending ? c : -c;
            if (c == 0) continue;
            return c;
        }
        return c;
    }
}

