/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.index;

import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.index.Index;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TreeIndex
implements Index {
    private final Map<Integer, TreeNode> indexNodeMap = new HashMap<Integer, TreeNode>();
    private TreeNode root = new TreeNode(null, null);
    private final Map<DataFrameColumn, Integer> columnIndexMap = new LinkedHashMap<DataFrameColumn, Integer>();
    private final String name;
    private boolean unique = false;

    protected TreeIndex(String indexName, boolean unique, DataFrameColumn ... columns) {
        int i = 0;
        for (DataFrameColumn column : columns) {
            this.columnIndexMap.put(column, i++);
        }
        this.name = indexName;
        this.unique = unique;
    }

    protected TreeIndex(String indexName, DataFrameColumn ... columns) {
        this(indexName, false, columns);
    }

    @Override
    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void clear() {
        this.indexNodeMap.clear();
        this.root.clear();
    }

    @Override
    public boolean containsColumn(DataFrameColumn column) {
        return this.columnIndexMap.containsKey(column);
    }

    @Override
    public List<DataFrameColumn> getColumns() {
        return new ArrayList<DataFrameColumn>(this.columnIndexMap.keySet());
    }

    @Override
    public void update(DataRow dataRow) {
        this.remove(dataRow);
        Comparable[] values = this.createValues(dataRow);
        this.addRec(this.root, 0, values, dataRow.getIndex());
    }

    private void addRec(TreeNode node, int index, Comparable[] values, Integer rowIndex) {
        if (index == values.length) {
            if (this.unique && node.hasIndices()) {
                throw new DataFrameRuntimeException(String.format("error adding row to index: duplicated values found '%s'", Arrays.toString(values)));
            }
            this.indexNodeMap.put(rowIndex, node);
            node.addIndex(rowIndex);
            return;
        }
        Comparable value = values[index];
        TreeNode child = node.getChild(value);
        if (child == null) {
            child = new TreeNode(node, value);
            node.addChild(child);
        }
        this.addRec(child, index + 1, values, rowIndex);
    }

    @Override
    public void remove(DataRow dataRow) {
        TreeNode node = this.indexNodeMap.get(dataRow.getIndex());
        if (node == null) {
            return;
        }
        node.removeIndex(dataRow.getIndex());
        this.removeRec(node);
    }

    private void removeRec(TreeNode node) {
        if (node.hasIndices() || node.hasChildren()) {
            return;
        }
        if (node.getParent() != null) {
            TreeNode parent = node.getParent();
            parent.removeChild(node.getValue());
            this.removeRec(parent);
        }
    }

    private Comparable[] createValues(DataRow dataRow) {
        Comparable[] values = new Comparable[this.columnIndexMap.size()];
        int i = 0;
        for (DataFrameColumn column : this.columnIndexMap.keySet()) {
            values[i++] = (Comparable)dataRow.get(column.getName());
        }
        return values;
    }

    @Override
    public Collection<Integer> find(Comparable ... values) {
        if (values.length != this.columnIndexMap.size()) {
            throw new IllegalArgumentException("value for each index column required");
        }
        TreeNode node = this.findRec(this.root, 0, values);
        if (node == null || !node.hasIndices()) {
            return new ArrayList<Integer>(0);
        }
        return node.getIndices();
    }

    private TreeNode findRec(TreeNode node, int index, Comparable[] values) {
        if (index == values.length) {
            return node;
        }
        Comparable value = values[index];
        TreeNode child = node.getChild(value);
        if (child == null) {
            return null;
        }
        return this.findRec(child, index + 1, values);
    }

    private class TreeNode {
        private Comparable value;
        private HashMap<Comparable, TreeNode> children;
        private List<Integer> indices;
        private TreeNode parent;

        public TreeNode(TreeNode parent, Comparable value) {
            this.value = value;
            this.parent = parent;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public void clear() {
            if (this.children != null) {
                this.children.clear();
            }
            if (this.indices != null) {
                this.indices.clear();
            }
        }

        private HashMap<Comparable, TreeNode> getChildrenMap() {
            if (this.children == null) {
                this.children = new HashMap();
            }
            return this.children;
        }

        public Collection<TreeNode> getChildren() {
            return this.getChildrenMap().values();
        }

        public Comparable getValue() {
            return this.value;
        }

        public void addChild(TreeNode child) {
            this.getChildrenMap().put(child.getValue(), child);
        }

        public TreeNode getChild(Comparable value) {
            return this.getChildrenMap().get(value);
        }

        public void removeChild(TreeNode child) {
            this.removeChild(child.getValue());
        }

        public void removeChild(Comparable value) {
            this.getChildrenMap().remove(value);
        }

        public void addIndex(Integer index) {
            this.getIndices().add(index);
        }

        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        public boolean hasIndices() {
            return this.indices != null && !this.indices.isEmpty();
        }

        public void removeIndex(Integer index) {
            this.getIndices().remove(index);
        }

        public Collection<Integer> getIndices() {
            if (this.indices == null) {
                this.indices = new ArrayList<Integer>();
            }
            return this.indices;
        }
    }
}

