/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.join;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameHeader;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.Values;
import de.unknownreality.dataframe.common.Row;
import de.unknownreality.dataframe.group.DataGroup;
import de.unknownreality.dataframe.join.JoinColumn;
import de.unknownreality.dataframe.join.JoinInfo;
import de.unknownreality.dataframe.join.JoinedDataFrame;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractJoin {
    public abstract JoinedDataFrame join(DataFrame var1, DataFrame var2, String var3, String var4, JoinColumn ... var5);

    public void fillValues(DataFrame dataFrame, DataRow row, JoinInfo joinInfo, Comparable[] joinedRowValues) {
        for (String headerName : dataFrame.getHeader()) {
            int joinedIndex = joinInfo.getJoinedIndex(headerName, dataFrame);
            joinedRowValues[joinedIndex] = (Comparable)row.get(headerName);
        }
    }

    public void fillNA(Comparable[] joinedRowValues) {
        for (int i = 0; i < joinedRowValues.length; ++i) {
            if (joinedRowValues[i] != null) continue;
            joinedRowValues[i] = Values.NA;
        }
    }

    public JoinInfo fillJoinHeader(DataFrameHeader joinHeader, DataFrame dfA, DataFrame dfB, JoinColumn[] joinColumns, String suffixA, String suffixB) {
        String name;
        HashSet<String> joinColumnSetA = new HashSet<String>();
        HashSet<String> joinColumnSetB = new HashSet<String>();
        HashMap<String, String> joinedBToAMap = new HashMap<String, String>();
        for (JoinColumn column : joinColumns) {
            joinColumnSetA.add(column.getColumnA());
            joinColumnSetB.add(column.getColumnB());
            joinedBToAMap.put(column.getColumnB(), column.getColumnA());
        }
        JoinInfo info = new JoinInfo(joinHeader, dfA, dfB);
        for (String s : dfA.getHeader()) {
            name = joinColumnSetA.contains(s) ? s : (dfB.getHeader().contains(s) ? s + suffixA : s);
            info.addDataFrameAHeader(s, name);
            joinHeader.add(name, dfA.getHeader().getColumnType(s), dfA.getHeader().getType(s));
        }
        for (String s : dfB.getHeader()) {
            if (joinColumnSetB.contains(s)) {
                name = (String)joinedBToAMap.get(s);
                info.addDataFrameBHeader(s, name);
                continue;
            }
            name = dfA.getHeader().contains(s) ? s + suffixB : s;
            info.addDataFrameBHeader(s, name);
            joinHeader.add(name, dfB.getHeader().getColumnType(s), dfB.getHeader().getType(s));
        }
        return info;
    }

    public void setGroupValuesA(Comparable[] groupValues, Row<Comparable, String> row, JoinColumn[] joinColumns) {
        for (int i = 0; i < joinColumns.length; ++i) {
            String headerName = joinColumns[i].getColumnA();
            groupValues[i] = row.get(headerName);
        }
    }

    public void setGroupValuesB(Comparable[] groupValues, Row<Comparable, String> row, JoinColumn[] joinColumns) {
        for (int i = 0; i < joinColumns.length; ++i) {
            String headerName = joinColumns[i].getColumnB();
            groupValues[i] = row.get(headerName);
        }
    }

    public void appendGroupJoinedRows(DataGroup group, DataFrame dfA, DataFrame dfB, DataRow rowA, JoinInfo joinInfo, DataFrameHeader joinHeader, List<DataRow> joinedRows) {
        for (DataRow rowB : group) {
            Comparable[] joinedRowValues = new Comparable[joinHeader.size()];
            this.fillValues(dfA, rowA, joinInfo, joinedRowValues);
            this.fillValues(dfB, rowB, joinInfo, joinedRowValues);
            this.fillNA(joinedRowValues);
            DataRow joinedRow = new DataRow(joinHeader, joinedRowValues, joinedRows.size());
            joinedRows.add(joinedRow);
        }
    }
}

