/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.join;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameHeader;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.group.DataGroup;
import de.unknownreality.dataframe.group.DataGrouping;
import de.unknownreality.dataframe.join.AbstractJoin;
import de.unknownreality.dataframe.join.JoinColumn;
import de.unknownreality.dataframe.join.JoinInfo;
import de.unknownreality.dataframe.join.JoinedDataFrame;
import java.util.ArrayList;

public abstract class DirectionJoin
extends AbstractJoin {
    public JoinedDataFrame createDirectionJoin(DataFrame dfA, DataFrame dfB, DataFrameHeader joinHeader, JoinInfo joinInfo, JoinColumn[] joinColumns) {
        String[] groupColumns = new String[joinColumns.length];
        for (int i = 0; i < joinColumns.length; ++i) {
            groupColumns[i] = joinColumns[i].getColumnB();
        }
        ArrayList<DataRow> joinedRows = new ArrayList<DataRow>();
        Comparable[] groupValues = new Comparable[joinColumns.length];
        DataGrouping joinedGroups = dfB.groupBy(groupColumns);
        for (DataRow row : dfA) {
            if (joinInfo.isA(dfA)) {
                this.setGroupValuesA(groupValues, row, joinColumns);
            } else {
                this.setGroupValuesB(groupValues, row, joinColumns);
            }
            DataGroup group = joinedGroups.findByGroupValues(groupValues);
            if (group == null) {
                Comparable[] joinedRowValues = new Comparable[joinHeader.size()];
                this.fillValues(dfA, row, joinInfo, joinedRowValues);
                this.fillNA(joinedRowValues);
                DataRow joinedRow = new DataRow(joinHeader, joinedRowValues, joinedRows.size());
                joinedRows.add(joinedRow);
                continue;
            }
            this.appendGroupJoinedRows(group, dfA, dfB, row, joinInfo, joinHeader, joinedRows);
        }
        JoinedDataFrame joinedDataFrame = new JoinedDataFrame(joinInfo);
        joinedDataFrame.set(joinHeader, joinedRows);
        return joinedDataFrame;
    }
}

