/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.join;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameHeader;
import de.unknownreality.dataframe.DataRow;
import de.unknownreality.dataframe.group.DataGroup;
import de.unknownreality.dataframe.group.DataGrouping;
import de.unknownreality.dataframe.join.AbstractJoin;
import de.unknownreality.dataframe.join.JoinColumn;
import de.unknownreality.dataframe.join.JoinInfo;
import de.unknownreality.dataframe.join.JoinedDataFrame;
import java.util.ArrayList;

public class InnerJoin
extends AbstractJoin {
    protected InnerJoin() {
    }

    @Override
    public JoinedDataFrame join(DataFrame dfA, DataFrame dfB, String joinSuffixA, String joinSuffixB, JoinColumn ... joinColumns) {
        DataFrameHeader joinHeader = new DataFrameHeader();
        JoinInfo joinInfo = this.fillJoinHeader(joinHeader, dfA, dfB, joinColumns, joinSuffixA, joinSuffixB);
        String[] groupColumns = new String[joinColumns.length];
        for (int i = 0; i < joinColumns.length; ++i) {
            groupColumns[i] = joinColumns[i].getColumnB();
        }
        ArrayList<DataRow> joinedRows = new ArrayList<DataRow>();
        Comparable[] groupValues = new Comparable[joinColumns.length];
        DataGrouping joinedGroups = dfB.groupBy(groupColumns);
        for (DataRow row : dfA) {
            this.setGroupValuesA(groupValues, row, joinColumns);
            DataGroup group = joinedGroups.findByGroupValues(groupValues);
            if (group == null) continue;
            this.appendGroupJoinedRows(group, dfA, dfB, row, joinInfo, joinHeader, joinedRows);
        }
        JoinedDataFrame joinedDataFrame = new JoinedDataFrame(joinInfo);
        joinedDataFrame.set(joinHeader, joinedRows);
        return joinedDataFrame;
    }
}

