/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.join;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameHeader;
import de.unknownreality.dataframe.DataFrameRuntimeException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class JoinInfo {
    private final DataFrameHeader header;
    private final WeakReference<DataFrame> dataFrameA;
    private final WeakReference<DataFrame> dataFrameB;
    private final Map<String, String> dataFrameAHeaderMap = new HashMap<String, String>();
    private final Map<String, String> dataFrameBHeaderMap = new HashMap<String, String>();

    public JoinInfo(DataFrameHeader header, DataFrame dataFrameA, DataFrame dataFrameB) {
        this.header = header;
        this.dataFrameA = new WeakReference<DataFrame>(dataFrameA);
        this.dataFrameB = new WeakReference<DataFrame>(dataFrameB);
    }

    public boolean isA(DataFrame dataFrame) {
        DataFrame df = (DataFrame)this.dataFrameA.get();
        return df != null && df == dataFrame;
    }

    public boolean isB(DataFrame dataFrame) {
        DataFrame df = (DataFrame)this.dataFrameB.get();
        return df != null && df == dataFrame;
    }

    protected void addDataFrameAHeader(String original, String joined) {
        this.dataFrameAHeaderMap.put(original, joined);
    }

    protected void addDataFrameBHeader(String original, String joined) {
        this.dataFrameBHeaderMap.put(original, joined);
    }

    public String getJoinedHeader(String original, DataFrame dataFrame) {
        if (this.isA(dataFrame)) {
            return this.getJoinedHeaderA(original);
        }
        if (this.isB(dataFrame)) {
            return this.getJoinedHeaderB(original);
        }
        throw new DataFrameRuntimeException("the provided data frame was not used for the join");
    }

    public int getJoinedIndex(String original, DataFrame dataFrame) {
        if (this.isA(dataFrame)) {
            return this.getJoinedIndexA(original);
        }
        if (this.isB(dataFrame)) {
            return this.getJoinedIndexB(original);
        }
        throw new DataFrameRuntimeException("the provided data frame was not used for the join");
    }

    public String getJoinedHeaderA(String original) {
        return this.dataFrameAHeaderMap.get(original);
    }

    public int getJoinedIndexA(String original) {
        return this.header.getIndex(this.getJoinedHeaderA(original));
    }

    public int getJoinedIndexB(String original) {
        return this.header.getIndex(this.getJoinedHeaderB(original));
    }

    public String getJoinedHeaderB(String original) {
        return this.dataFrameBHeaderMap.get(original);
    }
}

