/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.join;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.join.InnerJoin;
import de.unknownreality.dataframe.join.JoinColumn;
import de.unknownreality.dataframe.join.JoinedDataFrame;
import de.unknownreality.dataframe.join.LeftJoin;
import de.unknownreality.dataframe.join.RightJoin;

public class JoinUtil {
    public static final String JOIN_SUFFIX_A = ".A";
    public static final String JOIN_SUFFIX_B = ".B";
    public static final RightJoin RIGHT = new RightJoin();
    public static final LeftJoin LEFT = new LeftJoin();
    public static final InnerJoin INNER = new InnerJoin();

    public static JoinedDataFrame leftJoin(DataFrame dfA, DataFrame dfB, JoinColumn ... joinColumns) {
        return JoinUtil.leftJoin(dfA, dfB, JOIN_SUFFIX_A, JOIN_SUFFIX_B, joinColumns);
    }

    public static JoinedDataFrame leftJoin(DataFrame dfA, DataFrame dfB, String joinSuffixA, String joinSuffixB, JoinColumn ... joinColumns) {
        return LEFT.join(dfA, dfB, joinSuffixA, joinSuffixB, joinColumns);
    }

    public static JoinedDataFrame rightJoin(DataFrame dfA, DataFrame dfB, JoinColumn ... joinColumns) {
        return JoinUtil.rightJoin(dfA, dfB, JOIN_SUFFIX_A, JOIN_SUFFIX_B, joinColumns);
    }

    public static JoinedDataFrame rightJoin(DataFrame dfA, DataFrame dfB, String joinSuffixA, String joinSuffixB, JoinColumn ... joinColumns) {
        return RIGHT.join(dfA, dfB, joinSuffixA, joinSuffixB, joinColumns);
    }

    public static JoinedDataFrame innerJoin(DataFrame dfA, DataFrame dfB, JoinColumn ... joinColumns) {
        return JoinUtil.innerJoin(dfA, dfB, JOIN_SUFFIX_A, JOIN_SUFFIX_B, joinColumns);
    }

    public static JoinedDataFrame innerJoin(DataFrame dfA, DataFrame dfB, String joinSuffixA, String joinSuffixB, JoinColumn ... joinColumns) {
        return INNER.join(dfA, dfB, joinSuffixA, joinSuffixB, joinColumns);
    }
}

