/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.meta;

import de.unknownreality.dataframe.DataFrame;
import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.common.DataWriter;
import de.unknownreality.dataframe.common.ReaderBuilder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DataFrameMeta {
    public static final String META_FILE_EXTENSION = "dfm";
    private Class<? extends ReaderBuilder> readerBuilderClass;
    private Map<String, String> attributes = new HashMap<String, String>();
    private Map<String, Class<? extends DataFrameColumn>> columns = new LinkedHashMap<String, Class<? extends DataFrameColumn>>();

    public static DataFrameMeta create(DataFrame dataFrame, Class<? extends ReaderBuilder> readerBuilderClass, DataWriter dataWriterBuilder) {
        return DataFrameMeta.create(dataFrame, readerBuilderClass, dataWriterBuilder.getAttributes());
    }

    public static DataFrameMeta create(DataFrame dataFrame, Class<? extends ReaderBuilder> readerBuilderClass, Map<String, String> writerAttributes) {
        DataFrameMeta dataFrameMetaFile = new DataFrameMeta();
        dataFrameMetaFile.readerBuilderClass = readerBuilderClass;
        dataFrameMetaFile.attributes = writerAttributes;
        for (String header : dataFrame.getHeader()) {
            dataFrameMetaFile.columns.put(header, dataFrame.getHeader().getColumnType(header));
        }
        return dataFrameMetaFile;
    }

    public Class<? extends ReaderBuilder> getReaderBuilderClass() {
        return this.readerBuilderClass;
    }

    public Map<String, Class<? extends DataFrameColumn>> getColumns() {
        return this.columns;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public DataFrameMeta() {
    }

    public DataFrameMeta(Map<String, Class<? extends DataFrameColumn>> columns, Class<? extends ReaderBuilder> readerBuilderClass, Map<String, String> attributes) {
        this.columns = columns;
        this.readerBuilderClass = readerBuilderClass;
        this.attributes = attributes;
    }
}

