/*
 * Decompiled with CFR 0.152.
 */
package de.unknownreality.dataframe.meta;

import de.unknownreality.dataframe.DataFrameColumn;
import de.unknownreality.dataframe.DataFrameException;
import de.unknownreality.dataframe.common.ReaderBuilder;
import de.unknownreality.dataframe.meta.DataFrameMeta;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DataFrameMetaReader {
    private static Logger logger = LoggerFactory.getLogger(DataFrameMetaReader.class);
    private static final Map<String, String> LEGACY_PACKAGES = new TreeMap<String, String>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return -Integer.compare(o1.length(), o2.length());
        }
    });

    private DataFrameMetaReader() {
    }

    private static String remapLegacyPackages(String className) {
        for (Map.Entry<String, String> e : LEGACY_PACKAGES.entrySet()) {
            if (!className.contains(e.getKey())) continue;
            className = className.replace(e.getKey(), e.getValue());
            logger.warn("old package name found '{}'", (Object)e.getKey());
        }
        return className;
    }

    private static Class<? extends ReaderBuilder> findReaderBuilderClass(Element readerBuilder) throws DataFrameException {
        String rbClassString = readerBuilder.getAttribute("class");
        if (rbClassString == null) {
            throw new DataFrameException("no readerBuilder class attribute found");
        }
        return DataFrameMetaReader.parseChildClass(rbClassString, ReaderBuilder.class);
    }

    private static <T> Class<? extends T> parseChildClass(String clName, Class<T> parentType) throws DataFrameException {
        Class<?> cl;
        clName = DataFrameMetaReader.remapLegacyPackages(clName);
        try {
            cl = Class.forName(clName);
        }
        catch (ClassNotFoundException e) {
            throw new DataFrameException(String.format("class not found: %s", clName), e);
        }
        if (!parentType.isAssignableFrom(cl)) {
            throw new DataFrameException(String.format("%s does not extend %s", clName, parentType.getCanonicalName()));
        }
        return cl;
    }

    private static Map<String, String> findReaderBuilderAttributes(Element readerBuilder) throws DataFrameException {
        HashMap<String, String> readerBuilderAttributes = new HashMap<String, String>();
        NodeList attributes = readerBuilder.getElementsByTagName("readerAttribute");
        for (int i = 0; i < attributes.getLength(); ++i) {
            String value;
            String name;
            Node attributeNode = attributes.item(i);
            if (attributeNode.getNodeType() == 1) {
                Element attribute = (Element)attributeNode;
                name = attribute.getAttribute("name");
                if (name == null) {
                    throw new DataFrameException("no readerAttribute name attribute found");
                }
                value = attribute.getAttribute("value");
                if (value == null) {
                    throw new DataFrameException("no readerAttribute value attribute found");
                }
            } else {
                throw new DataFrameException("error parsing attributeElement element");
            }
            readerBuilderAttributes.put(name, value);
        }
        return readerBuilderAttributes;
    }

    private static LinkedHashMap<String, Class<? extends DataFrameColumn>> findColumns(Element columns) throws DataFrameException {
        LinkedHashMap<String, Class<? extends DataFrameColumn>> columnsMap = new LinkedHashMap<String, Class<? extends DataFrameColumn>>();
        NodeList columnNodes = columns.getElementsByTagName("column");
        for (int i = 0; i < columnNodes.getLength(); ++i) {
            String type;
            String name;
            Node columnNode = columnNodes.item(i);
            if (columnNode.getNodeType() == 1) {
                Element column = (Element)columnNode;
                name = column.getAttribute("name");
                if (name == null) {
                    throw new DataFrameException("no column name attribute found");
                }
                type = column.getAttribute("type");
                if (type == null) {
                    throw new DataFrameException("no column type attribute found");
                }
            } else {
                throw new DataFrameException("error parsing column element");
            }
            Class<DataFrameColumn> cl = DataFrameMetaReader.parseChildClass(type, DataFrameColumn.class);
            columnsMap.put(name, cl);
        }
        return columnsMap;
    }

    public static DataFrameMeta read(File file) throws DataFrameException {
        try {
            return DataFrameMetaReader.read(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new DataFrameException("error reading the meta file", e);
        }
    }

    public static DataFrameMeta read(InputStream is) throws DataFrameException {
        Document doc;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.parse(is);
            doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new DataFrameException("error parsing dataFrameMeta file ", e);
        }
        catch (IOException e) {
            throw new DataFrameException("error reading dataFrameMeta file ", e);
        }
        NodeList readBuilderElements = doc.getElementsByTagName("readerBuilder");
        if (readBuilderElements.getLength() == 0) {
            throw new DataFrameException("no readerBuilder element found");
        }
        if (readBuilderElements.getLength() > 1) {
            throw new DataFrameException("multiple readerBuilder elements found");
        }
        Node readerBuilderNode = readBuilderElements.item(0);
        if (readerBuilderNode.getNodeType() != 1) {
            throw new DataFrameException("error parsing readerBuilder element");
        }
        Element readerBuilder = (Element)readerBuilderNode;
        Class<? extends ReaderBuilder> readerBuilderClass = DataFrameMetaReader.findReaderBuilderClass(readerBuilder);
        Map<String, String> readerBuilderAttributes = DataFrameMetaReader.findReaderBuilderAttributes(readerBuilder);
        NodeList columnsElements = doc.getElementsByTagName("columns");
        if (columnsElements.getLength() == 0) {
            throw new DataFrameException("no columns element found");
        }
        if (columnsElements.getLength() > 1) {
            throw new DataFrameException("multiple columns elements found");
        }
        Node columnsNode = columnsElements.item(0);
        if (columnsNode.getNodeType() != 1) {
            throw new DataFrameException("error parsing columns element");
        }
        Element columnsElement = (Element)columnsNode;
        LinkedHashMap<String, Class<? extends DataFrameColumn>> columns = DataFrameMetaReader.findColumns(columnsElement);
        return new DataFrameMeta(columns, readerBuilderClass, readerBuilderAttributes);
    }

    static {
        LEGACY_PACKAGES.put("de.unknownreality.data.", "de.unknownreality.dataframe.");
        LEGACY_PACKAGES.put("de.unknownreality.data.frame.", "de.unknownreality.dataframe.");
    }
}

